"""
Auth Context - Singleton global para almacenar JWT token del usuario autenticado.

⚠️ ⚠️ ⚠️ DEPRECADO - NO USAR EN CÓDIGO NUEVO ⚠️ ⚠️ ⚠️

Este módulo está DEPRECADO desde la migración del Issue #348 (RBAC).
Se mantiene SOLO para backward compatibility temporal.

❌ NO USAR: auth_context.get_auth_headers()
❌ NO USAR: auth_context.set_token(token)
❌ NO USAR: auth_context.clear_token()

✅ USAR EN SU LUGAR:
    from utils.auth import auth_manager

    access_token = auth_manager.get_access_token()
    auth_manager.save_tokens(access_token, refresh_token)
    auth_manager.clear_tokens()

Razones de la deprecación:
- auth_manager es thread-safe para multi-worker (Render)
- auth_manager maneja encriptación/desencriptación automáticamente
- auth_manager es el sistema oficial RBAC (Issue #348)
- auth_context será eliminado en futuras versiones

Referencias:
- Issue #348: Panel de Administración Unificado con RBAC
- CLAUDE.md REGLA #7: Security First (JWT authentication)
- frontend/utils/auth.py: Implementación oficial auth_manager

Fecha de deprecación: 2025-11-01
Fecha de eliminación planeada: 2025-12-01
"""

import logging
import warnings

logger = logging.getLogger(__name__)

# Warning al importar el módulo (solo mostrar una vez)
warnings.warn(
    "auth_context is DEPRECATED. Use 'from utils.auth import auth_manager' instead. "
    "See Issue #348 for migration guide. This module will be removed in December 2025.",
    DeprecationWarning,
    stacklevel=2
)


class AuthContext:
    """Singleton global para almacenar token JWT del usuario autenticado."""

    _instance = None
    _token = None

    def __new__(cls):
        """Implementación singleton - solo una instancia en todo el proceso Python."""
        if cls._instance is None:
            cls._instance = super().__new__(cls)
        return cls._instance

    def set_token(self, token: str):
        """
        Establecer el token JWT actual.

        Args:
            token: JWT access token del usuario autenticado
        """
        self._token = token

    def clear_token(self):
        """Limpiar el token (usado en logout)."""
        self._token = None

    def get_auth_headers(self) -> dict:
        """
        Obtener headers de autenticación para requests HTTP.

        Returns:
            Dict con Authorization header si hay token, dict vacío si no
        """
        if self._token:
            return {"Authorization": f"Bearer {self._token}"}
        return {}


# Instancia singleton global (importar desde otros módulos)
auth_context = AuthContext()
