# frontend/utils/__init__.py
"""
Módulo de utilidades para el frontend de xfarma.
Incluye clients para API, helpers y constantes.
"""

from .api_client import BackendClient
from .constants import CHART_THEMES, COLORS, DATE_FORMATS
from .helpers import format_currency, format_percentage, safe_divide

__all__ = [
    "BackendClient",
    "COLORS",
    "CHART_THEMES",
    "DATE_FORMATS",
    "format_currency",
    "format_percentage",
    "safe_divide",
]
