# frontend/stores/__init__.py
"""
Centralized Stores for kaiFarma Frontend (Pivot 2026)

Stores are dcc.Store objects that hold application state.
This module provides factory functions and type definitions.

Pattern: "Smart Store, Dumb Component"
- Stores aggregate and transform data from multiple sources
- Components only read and render, no business logic

Available Stores:
- global-alerts-store: Aggregated alerts from all modules
- (future) preferences-store: User preferences
- (future) cache-store: API response cache

Usage in app.py:
    from stores.alerts_store import get_empty_alerts_state

    app.layout = html.Div([
        dcc.Store(id='global-alerts-store', data=get_empty_alerts_state()),
        ...
    ])
"""

from stores.alerts_store import (
    # Factory functions
    get_empty_alerts_state,
    build_module_alert,
    build_system_status,
    aggregate_alerts,
    # Module-specific builders
    build_encargos_alert,
    build_erp_status,
    # Types (TypedDict for type hints)
    AlertStatus,
    ModuleAlert,
    SystemStatus,
    AlertsSummary,
    AlertsState,
    # Thresholds (configurable)
    ENCARGOS_CRITICAL_DAYS,
    ENCARGOS_WARNING_DAYS,
    ERP_SYNC_OK_MINUTES,
    ERP_SYNC_WARNING_MINUTES,
    ERP_SYNC_CRITICAL_MINUTES,
    CIMA_SYNC_OK_DAYS,
    CIMA_SYNC_WARNING_DAYS,
    CIMA_SYNC_CRITICAL_DAYS,
)

__all__ = [
    # Factory functions
    "get_empty_alerts_state",
    "build_module_alert",
    "build_system_status",
    "aggregate_alerts",
    # Module-specific builders
    "build_encargos_alert",
    "build_erp_status",
    # Types
    "AlertStatus",
    "ModuleAlert",
    "SystemStatus",
    "AlertsSummary",
    "AlertsState",
    # Thresholds
    "ENCARGOS_CRITICAL_DAYS",
    "ENCARGOS_WARNING_DAYS",
    "ERP_SYNC_OK_MINUTES",
    "ERP_SYNC_WARNING_MINUTES",
    "ERP_SYNC_CRITICAL_MINUTES",
    "CIMA_SYNC_OK_DAYS",
    "CIMA_SYNC_WARNING_DAYS",
    "CIMA_SYNC_CRITICAL_DAYS",
]
