#!/usr/bin/env python3
"""
Script de inicio para xfarma frontend en producción.
Maneja puerto dinámico para deployment en Render.com
"""

import os

from app import app

if __name__ == "__main__":
    # Obtener puerto de variable de entorno (Render lo proporciona dinámicamente)
    port = int(os.getenv("PORT", 8050))

    # Obtener configuración del entorno
    environment = os.getenv("ENVIRONMENT", "development")

    # Validación de entorno al inicio
    valid_environments = ["development", "production", "staging", "test"]
    if environment.lower() not in valid_environments:
        print(f"⚠️ WARNING: Invalid ENVIRONMENT value: '{environment}'")
        print(f"   Valid values: {', '.join(valid_environments)}")
        print("   Defaulting to: development")
        environment = "development"

    print("🚀 Starting xFarma Frontend")
    print(f"   Environment: {environment}")
    print(f"   Port: {port}")
    print(f"   Auth Bypass: {'ENABLED' if environment == 'development' else 'DISABLED'}")

    # Configurar servidor para producción o desarrollo
    if environment == "production":
        # Configuración para producción
        app.run(
            debug=False,
            host="0.0.0.0",
            port=port,
            dev_tools_hot_reload=False,
            dev_tools_ui=False,
            dev_tools_silence_routes_logging=True,
        )
    else:
        # Configuración para desarrollo local
        app.run(debug=True, host="0.0.0.0", port=port, dev_tools_hot_reload=True)
