"""
Página de Prueba del Design System xFarma

Página visual para demostrar y probar todos los componentes base del sistema de diseño:
- BaseCard (default y highlighted)
- BaseButton (6 variantes x 3 tamaños)
- Title (5 niveles jerárquicos)
- Ejemplos de uso común (card con título + botón)

Uso: Navegar a /test-design-system
"""

import dash_bootstrap_components as dbc
from components.base import BaseButton, BaseCard, Title
from dash import html
from styles.design_tokens import BORDER_RADIUS, COLORS, SPACING


def create_test_design_system_layout():
    """
    Crear layout de prueba del sistema de diseño.

    Returns:
        html.Div: Layout completo con ejemplos de todos los componentes
    """

    return html.Div(
        [
            # Título principal de la página
            Title("Sistema de Diseño xFarma", level=1, margin_bottom=SPACING["s"]),
            html.P(
                "Demostración visual de componentes base y design tokens",
                style={"color": COLORS["text_secondary"], "marginBottom": SPACING["xl"], "fontSize": "1.125rem"},
            ),
            # ============================================================================
            # SECCIÓN: TITLES
            # ============================================================================
            html.Div(
                [
                    Title("Títulos (Typography)", level=2, margin_bottom=SPACING["l"]),
                    BaseCard(
                        children=[
                            Title("Título Nivel 1 (h1) - Títulos principales de página", level=1),
                            Title("Título Nivel 2 (h2) - Títulos de sección importante", level=2),
                            Title("Título Nivel 3 (h3) - Subtítulos destacados", level=3),
                            Title("Título Nivel 4 (h4) - Subtítulos secundarios", level=4),
                            Title("Título Nivel 5 (h5) - Títulos terciarios", level=5),
                            html.Hr(style={"margin": f"{SPACING['l']} 0"}),
                            Title("Títulos con Colores", level=3, margin_bottom=SPACING["m"]),
                            Title("Título Primary", level=4, color="primary"),
                            Title("Título Success", level=4, color="success"),
                            Title("Título Warning", level=4, color="warning"),
                            Title("Título Danger", level=4, color="danger"),
                        ],
                        variant="default",
                        shadow="sm",
                    ),
                ],
                style={"marginBottom": SPACING["2xl"]},
            ),
            # ============================================================================
            # SECCIÓN: CARDS
            # ============================================================================
            html.Div(
                [
                    Title("Tarjetas (Cards)", level=2, margin_bottom=SPACING["l"]),
                    dbc.Row(
                        [
                            # Card Default
                            dbc.Col(
                                [
                                    Title("Card Default", level=4, margin_bottom=SPACING["m"]),
                                    BaseCard(
                                        children=[
                                            Title("Título de Card", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Esta es una tarjeta estándar con fondo blanco y borde sutil."),
                                            html.P(
                                                "Ideal para contenedores de información, KPIs, resúmenes y widgets.",
                                                style={"marginBottom": "0"},
                                            ),
                                        ],
                                        variant="default",
                                        shadow="sm",
                                    ),
                                ],
                                width=12,
                                lg=6,
                                className="mb-4",
                            ),
                            # Card Highlighted
                            dbc.Col(
                                [
                                    Title("Card Highlighted", level=4, margin_bottom=SPACING["m"]),
                                    BaseCard(
                                        children=[
                                            Title("Card Destacada", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Esta tarjeta está destacada con borde izquierdo coloreado."),
                                            html.P(
                                                "Útil para resaltar información importante o alertas.",
                                                style={"marginBottom": "0"},
                                            ),
                                        ],
                                        variant="highlighted",
                                        shadow="sm",
                                    ),
                                ],
                                width=12,
                                lg=6,
                                className="mb-4",
                            ),
                        ]
                    ),
                    # Cards con diferentes sombras
                    Title("Cards con Diferentes Sombras", level=4, margin_bottom=SPACING["m"]),
                    dbc.Row(
                        [
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Shadow: none", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Sin sombra", style={"marginBottom": "0"}),
                                        ],
                                        shadow="none",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=3,
                                className="mb-4",
                            ),
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Shadow: sm", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Sombra pequeña", style={"marginBottom": "0"}),
                                        ],
                                        shadow="sm",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=3,
                                className="mb-4",
                            ),
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Shadow: md", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Sombra media", style={"marginBottom": "0"}),
                                        ],
                                        shadow="md",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=3,
                                className="mb-4",
                            ),
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Shadow: lg", level=5, margin_bottom=SPACING["s"]),
                                            html.P("Sombra grande", style={"marginBottom": "0"}),
                                        ],
                                        shadow="lg",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=3,
                                className="mb-4",
                            ),
                        ]
                    ),
                ],
                style={"marginBottom": SPACING["2xl"]},
            ),
            # ============================================================================
            # SECCIÓN: BUTTONS
            # ============================================================================
            html.Div(
                [
                    Title("Botones (Buttons)", level=2, margin_bottom=SPACING["l"]),
                    # Botones Sólidos
                    BaseCard(
                        [
                            Title("Botones Sólidos", level=4, margin_bottom=SPACING["m"]),
                            # Tamaño Large
                            html.Div(
                                [
                                    html.P(
                                        "Tamaño Large (lg):", style={"fontWeight": "500", "marginBottom": SPACING["s"]}
                                    ),
                                    html.Div(
                                        [
                                            BaseButton("Primary", variant="primary", size="lg", id="btn-primary-lg"),
                                            BaseButton(
                                                "Secondary", variant="secondary", size="lg", id="btn-secondary-lg"
                                            ),
                                            BaseButton("Success", variant="success", size="lg", id="btn-success-lg"),
                                            BaseButton("Danger", variant="danger", size="lg", id="btn-danger-lg"),
                                            BaseButton("Warning", variant="warning", size="lg", id="btn-warning-lg"),
                                            BaseButton("Info", variant="info", size="lg", id="btn-info-lg"),
                                        ],
                                        style={
                                            "display": "flex",
                                            "gap": SPACING["s"],
                                            "flexWrap": "wrap",
                                            "marginBottom": SPACING["l"],
                                        },
                                    ),
                                ]
                            ),
                            # Tamaño Medium (default)
                            html.Div(
                                [
                                    html.P(
                                        "Tamaño Medium (md) - Default:",
                                        style={"fontWeight": "500", "marginBottom": SPACING["s"]},
                                    ),
                                    html.Div(
                                        [
                                            BaseButton("Primary", variant="primary", size="md", id="btn-primary-md"),
                                            BaseButton(
                                                "Secondary", variant="secondary", size="md", id="btn-secondary-md"
                                            ),
                                            BaseButton("Success", variant="success", size="md", id="btn-success-md"),
                                            BaseButton("Danger", variant="danger", size="md", id="btn-danger-md"),
                                            BaseButton("Warning", variant="warning", size="md", id="btn-warning-md"),
                                            BaseButton("Info", variant="info", size="md", id="btn-info-md"),
                                        ],
                                        style={
                                            "display": "flex",
                                            "gap": SPACING["s"],
                                            "flexWrap": "wrap",
                                            "marginBottom": SPACING["l"],
                                        },
                                    ),
                                ]
                            ),
                            # Tamaño Small
                            html.Div(
                                [
                                    html.P(
                                        "Tamaño Small (sm):", style={"fontWeight": "500", "marginBottom": SPACING["s"]}
                                    ),
                                    html.Div(
                                        [
                                            BaseButton("Primary", variant="primary", size="sm", id="btn-primary-sm"),
                                            BaseButton(
                                                "Secondary", variant="secondary", size="sm", id="btn-secondary-sm"
                                            ),
                                            BaseButton("Success", variant="success", size="sm", id="btn-success-sm"),
                                            BaseButton("Danger", variant="danger", size="sm", id="btn-danger-sm"),
                                            BaseButton("Warning", variant="warning", size="sm", id="btn-warning-sm"),
                                            BaseButton("Info", variant="info", size="sm", id="btn-info-sm"),
                                        ],
                                        style={"display": "flex", "gap": SPACING["s"], "flexWrap": "wrap"},
                                    ),
                                ]
                            ),
                        ],
                        variant="default",
                        shadow="sm",
                    ),
                    # Botones Outline
                    BaseCard(
                        [
                            Title("Botones Outline", level=4, margin_bottom=SPACING["m"]),
                            html.Div(
                                [
                                    BaseButton("Primary", variant="primary", outline=True, id="btn-outline-primary"),
                                    BaseButton(
                                        "Secondary", variant="secondary", outline=True, id="btn-outline-secondary"
                                    ),
                                    BaseButton("Success", variant="success", outline=True, id="btn-outline-success"),
                                    BaseButton("Danger", variant="danger", outline=True, id="btn-outline-danger"),
                                    BaseButton("Warning", variant="warning", outline=True, id="btn-outline-warning"),
                                    BaseButton("Info", variant="info", outline=True, id="btn-outline-info"),
                                ],
                                style={"display": "flex", "gap": SPACING["s"], "flexWrap": "wrap"},
                            ),
                        ],
                        variant="default",
                        shadow="sm",
                        style={"marginTop": SPACING["l"]},
                    ),
                    # Botones Deshabilitados
                    BaseCard(
                        [
                            Title("Botones Deshabilitados", level=4, margin_bottom=SPACING["m"]),
                            html.Div(
                                [
                                    BaseButton("Primary", variant="primary", disabled=True),
                                    BaseButton("Secondary", variant="secondary", disabled=True),
                                    BaseButton("Success", variant="success", disabled=True, outline=True),
                                ],
                                style={"display": "flex", "gap": SPACING["s"], "flexWrap": "wrap"},
                            ),
                        ],
                        variant="default",
                        shadow="sm",
                        style={"marginTop": SPACING["l"]},
                    ),
                ],
                style={"marginBottom": SPACING["2xl"]},
            ),
            # ============================================================================
            # SECCIÓN: PATRONES DE USO COMÚN
            # ============================================================================
            html.Div(
                [
                    Title("Patrones de Uso Común", level=2, margin_bottom=SPACING["l"]),
                    dbc.Row(
                        [
                            # Patrón 1: KPI Card
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Ventas Totales", level=4, margin_bottom=SPACING["xs"]),
                                            html.H2(
                                                "€25,450",
                                                style={
                                                    "color": COLORS["success"],
                                                    "marginBottom": SPACING["xs"],
                                                    "fontWeight": "300",
                                                },
                                            ),
                                            html.P(
                                                "↑ 12.5% vs mes anterior",
                                                style={
                                                    "fontSize": "0.875rem",
                                                    "color": COLORS["text_secondary"],
                                                    "marginBottom": "0",
                                                },
                                            ),
                                        ],
                                        variant="default",
                                        shadow="sm",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=4,
                                className="mb-4",
                            ),
                            # Patrón 2: Card con Acción
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Productos con Bajo Stock", level=4, margin_bottom=SPACING["s"]),
                                            html.P("Hay 15 productos que requieren reposición."),
                                            BaseButton(
                                                "Ver Detalles", variant="warning", size="sm", id="btn-pattern-action"
                                            ),
                                        ],
                                        variant="highlighted",
                                        shadow="md",
                                    )
                                ],
                                width=12,
                                md=6,
                                lg=4,
                                className="mb-4",
                            ),
                            # Patrón 3: Card Informativa
                            dbc.Col(
                                [
                                    BaseCard(
                                        children=[
                                            Title("Última Actualización", level=4, margin_bottom=SPACING["s"]),
                                            html.P("Catálogo sincronizado hace 2 horas."),
                                            html.Div(
                                                [
                                                    BaseButton(
                                                        "Sincronizar", variant="info", size="sm", id="btn-pattern-sync"
                                                    ),
                                                    BaseButton(
                                                        "Detalles",
                                                        variant="secondary",
                                                        size="sm",
                                                        outline=True,
                                                        id="btn-pattern-details",
                                                    ),
                                                ],
                                                style={"display": "flex", "gap": SPACING["s"]},
                                            ),
                                        ],
                                        variant="default",
                                        shadow="sm",
                                    )
                                ],
                                width=12,
                                md=12,
                                lg=4,
                                className="mb-4",
                            ),
                        ]
                    ),
                ],
                style={"marginBottom": SPACING["2xl"]},
            ),
            # ============================================================================
            # SECCIÓN: DESIGN TOKENS
            # ============================================================================
            html.Div(
                [
                    Title("Design Tokens", level=2, margin_bottom=SPACING["l"]),
                    BaseCard(
                        [
                            Title("Colores", level=4, margin_bottom=SPACING["m"]),
                            dbc.Row(
                                [
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["primary"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P(
                                                        "Primary", style={"fontSize": "0.875rem", "marginBottom": "0"}
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["success"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P(
                                                        "Success", style={"fontSize": "0.875rem", "marginBottom": "0"}
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["info"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P("Info", style={"fontSize": "0.875rem", "marginBottom": "0"}),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["warning"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P(
                                                        "Warning", style={"fontSize": "0.875rem", "marginBottom": "0"}
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["danger"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P(
                                                        "Danger", style={"fontSize": "0.875rem", "marginBottom": "0"}
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.Div(
                                                        style={
                                                            "width": "50px",
                                                            "height": "50px",
                                                            "backgroundColor": COLORS["secondary"],
                                                            "borderRadius": BORDER_RADIUS["md"],
                                                            "marginBottom": SPACING["xs"],
                                                        }
                                                    ),
                                                    html.P(
                                                        "Secondary", style={"fontSize": "0.875rem", "marginBottom": "0"}
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=6,
                                        md=4,
                                        lg=2,
                                        className="mb-3",
                                    ),
                                ]
                            ),
                        ],
                        variant="default",
                        shadow="sm",
                    ),
                ],
                style={"marginBottom": SPACING["2xl"]},
            ),
        ],
        style={"padding": SPACING["xl"], "maxWidth": "1400px", "margin": "0 auto"},
    )
