# frontend/layouts/landing.py
"""
Landing page profesional de kaiFarma con login integrado.
Página pública de presentación con formulario de login.
"""

import os

import dash_bootstrap_components as dbc
from dash import html

# Configuración de backend (mismo patrón que app.py)
# Prioridad: BACKEND_URL > RENDER_EXTERNAL_URL > localhost:8000
BACKEND_URL = os.getenv("BACKEND_URL", os.getenv("RENDER_EXTERNAL_URL", "http://localhost:8000"))


def create_landing_layout():
    """
    Crea el layout de la landing page con presentación de kaiFarma y login integrado.

    Features:
    - Hero section con logo y mensaje principal
    - Formulario de login integrado (solo email/password)
    - Sección de características del sistema
    - Footer informativo
    - Diseño responsive (375px, 768px, 1440px)

    Returns:
        dbc.Container: Layout completo de la landing page
    """
    return html.Div(
        [
            # Hero Section con gradiente
            html.Div(
                [
                    dbc.Container(
                        [
                            dbc.Row(
                                [
                                    # Columna izquierda: Presentación
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    # Logo y título principal
                                                    html.Div(
                                                        [
                                                            html.I(
                                                                className="fas fa-pills fa-4x mb-4",
                                                                style={
                                                                    "color": "white",
                                                                    "filter": "drop-shadow(0 4px 6px rgba(0, 0, 0, 0.1))",
                                                                },
                                                            ),
                                                            html.H1(
                                                                "kaiFarma",
                                                                className="display-3 fw-bold text-white mb-3",
                                                                style={"textShadow": "0 2px 4px rgba(0, 0, 0, 0.1)"},
                                                            ),
                                                            html.H2(
                                                                "El valor del momento exacto",
                                                                className="h4 text-white mb-4",
                                                                style={
                                                                    "fontWeight": "400",
                                                                    "opacity": "0.95",
                                                                    "textShadow": "0 1px 2px rgba(0, 0, 0, 0.1)",
                                                                },
                                                            ),
                                                            html.P(
                                                                [
                                                                    "Mientras tú atiendes pacientes, kaiFarma busca oportunidades de compra, ",
                                                                    "detecta stock muerto antes de que se convierta en pérdida ",
                                                                    "y audita tus facturas. La diferencia entre gestionar y aprovechar.",
                                                                ],
                                                                className="lead text-white mb-4",
                                                                style={
                                                                    "fontSize": "1.1rem",
                                                                    "opacity": "0.9",
                                                                    "lineHeight": "1.7",
                                                                },
                                                            ),
                                                        ],
                                                        className="text-center text-lg-start mb-4 mb-lg-0",
                                                    )
                                                ],
                                                className="d-flex flex-column justify-content-center h-100 py-5 py-lg-0",
                                            )
                                        ],
                                        width=12,
                                        lg=6,
                                        className="mb-4 mb-lg-0",
                                    ),
                                    # Columna derecha: Formulario de login
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    dbc.Card(
                                                        [
                                                            dbc.CardBody(
                                                                [
                                                                    html.H3(
                                                                        "Iniciar Sesión",
                                                                        className="card-title text-center mb-4",
                                                                        style={"color": "#343a40", "fontWeight": "600"},
                                                                    ),
                                                                    # Mensajes de alerta
                                                                    html.Div(id="login-alert", className="mb-3"),
                                                                    # Formulario de login
                                                                    dbc.Form(
                                                                        [
                                                                            # Email
                                                                            dbc.Row(
                                                                                [
                                                                                    dbc.Col(
                                                                                        [
                                                                                            dbc.Label(
                                                                                                "Email",
                                                                                                html_for="login-email",
                                                                                                className="fw-semibold",
                                                                                            ),
                                                                                            dbc.Input(
                                                                                                type="email",
                                                                                                id="login-email",
                                                                                                placeholder="tu@email.com",
                                                                                                required=True,
                                                                                                autoComplete="email",
                                                                                                invalid=False,
                                                                                                style={
                                                                                                    "borderRadius": "6px",
                                                                                                    "padding": "12px 16px",
                                                                                                    "fontSize": "16px",
                                                                                                },
                                                                                            ),
                                                                                            dbc.FormFeedback(
                                                                                                "Por favor ingresa un email válido",
                                                                                                type="invalid",
                                                                                            ),
                                                                                        ],
                                                                                        className="mb-3",
                                                                                    ),
                                                                                ]
                                                                            ),
                                                                            # Password
                                                                            dbc.Row(
                                                                                [
                                                                                    dbc.Col(
                                                                                        [
                                                                                            dbc.Label(
                                                                                                "Contraseña",
                                                                                                html_for="login-password",
                                                                                                className="fw-semibold",
                                                                                            ),
                                                                                            dbc.Input(
                                                                                                type="password",
                                                                                                id="login-password",
                                                                                                placeholder="Tu contraseña",
                                                                                                required=True,
                                                                                                autoComplete="current-password",
                                                                                                style={
                                                                                                    "borderRadius": "6px",
                                                                                                    "padding": "12px 16px",
                                                                                                    "fontSize": "16px",
                                                                                                },
                                                                                            ),
                                                                                        ],
                                                                                        className="mb-3",
                                                                                    ),
                                                                                ]
                                                                            ),
                                                                            # Recordar sesión
                                                                            dbc.Row(
                                                                                [
                                                                                    dbc.Col(
                                                                                        [
                                                                                            dbc.Checkbox(
                                                                                                id="remember-me",
                                                                                                label="Recordar sesión",
                                                                                                value=False,
                                                                                                className="mb-3",
                                                                                            ),
                                                                                        ]
                                                                                    ),
                                                                                ]
                                                                            ),
                                                                            # Botón de login con spinner
                                                                            html.Div(
                                                                                [
                                                                                    dbc.Button(
                                                                                        [
                                                                                            html.I(
                                                                                                className="fas fa-sign-in-alt me-2",
                                                                                                id="login-button-icon",
                                                                                            ),
                                                                                            html.Span(
                                                                                                "Iniciar Sesión",
                                                                                                id="login-button-text",
                                                                                            ),
                                                                                        ],
                                                                                        id="login-button",
                                                                                        color="primary",
                                                                                        size="lg",
                                                                                        className="w-100",
                                                                                        n_clicks=0,
                                                                                        disabled=False,
                                                                                        style={
                                                                                            "padding": "12px",
                                                                                            "fontSize": "1.1rem",
                                                                                            "fontWeight": "600",
                                                                                            "borderRadius": "6px",
                                                                                            "boxShadow": "0 4px 6px rgba(13, 110, 253, 0.15)",
                                                                                        },
                                                                                    ),
                                                                                ],
                                                                                className="mb-3",
                                                                            ),
                                                                        ]
                                                                    ),
                                                                    # Links adicionales
                                                                    html.Div(
                                                                        [
                                                                            html.A(
                                                                                "¿Olvidaste tu contraseña?",
                                                                                href="/auth/forgot-password",
                                                                                className="d-block text-center",
                                                                                style={
                                                                                    "fontSize": "0.9rem",
                                                                                    "color": "#0066CC",
                                                                                    "textDecoration": "none",
                                                                                },
                                                                            ),
                                                                        ],
                                                                        className="mt-3",
                                                                    ),
                                                                ],
                                                                style={"padding": "2rem"},
                                                            )
                                                        ],
                                                        className="shadow-lg",
                                                        style={"borderRadius": "12px"},
                                                    )
                                                ],
                                                className="d-flex flex-column justify-content-center h-100",
                                            )
                                        ],
                                        width=12,
                                        lg=5,
                                        className="offset-lg-1",
                                    ),
                                ],
                                className="align-items-center",
                                style={"minHeight": "100vh", "paddingTop": "2rem", "paddingBottom": "2rem"},
                            )
                        ],
                        fluid=True,
                        style={"maxWidth": "1400px"},
                    )
                ],
                style={
                    "background": "linear-gradient(135deg, #0d6efd 0%, #0a58ca 50%, #084298 100%)",
                    "minHeight": "100vh",
                    "position": "relative",
                    "overflow": "hidden",
                },
            ),
            # Sección de características
            html.Div(
                [
                    dbc.Container(
                        [
                            # Título de la sección
                            html.Div(
                                [
                                    html.H2(
                                        "¿Por qué elegir kaiFarma?",
                                        className="text-center mb-4",
                                        style={"fontWeight": "700", "color": "#343a40"},
                                    ),
                                    html.P(
                                        "La solución integral para la gestión moderna de tu farmacia",
                                        className="text-center text-muted mb-5",
                                        style={"fontSize": "1.1rem"},
                                    ),
                                ]
                            ),
                            # Cards de características
                            dbc.Row(
                                [
                                    # Feature 1: Análisis de Ventas
                                    dbc.Col(
                                        [
                                            dbc.Card(
                                                [
                                                    dbc.CardBody(
                                                        [
                                                            html.Div(
                                                                [
                                                                    html.I(
                                                                        className="fas fa-chart-line fa-3x mb-3",
                                                                        style={"color": "#0d6efd"},
                                                                    ),
                                                                    html.H4(
                                                                        "Análisis Inteligente de Ventas",
                                                                        className="card-title mb-3",
                                                                        style={"fontWeight": "600"},
                                                                    ),
                                                                    html.P(
                                                                        [
                                                                            "Visualiza y analiza las ventas de tu farmacia con dashboards interactivos. ",
                                                                            "Identifica tendencias, productos estrella y oportunidades de mejora ",
                                                                            "con gráficos claros y métricas accionables.",
                                                                        ],
                                                                        className="card-text",
                                                                        style={"lineHeight": "1.7", "color": "#6c757d"},
                                                                    ),
                                                                ],
                                                                className="text-center",
                                                            )
                                                        ],
                                                        style={"padding": "2rem"},
                                                    )
                                                ],
                                                className="h-100 shadow-sm",
                                                style={"borderRadius": "10px", "border": "none"},
                                            )
                                        ],
                                        width=12,
                                        md=6,
                                        lg=4,
                                        className="mb-4",
                                    ),
                                    # Feature 2: Integración CIMA
                                    dbc.Col(
                                        [
                                            dbc.Card(
                                                [
                                                    dbc.CardBody(
                                                        [
                                                            html.Div(
                                                                [
                                                                    html.I(
                                                                        className="fas fa-database fa-3x mb-3",
                                                                        style={"color": "#28a745"},
                                                                    ),
                                                                    html.H4(
                                                                        "Integración con CIMA",
                                                                        className="card-title mb-3",
                                                                        style={"fontWeight": "600"},
                                                                    ),
                                                                    html.P(
                                                                        [
                                                                            "Enriquecimiento automático de datos con la base de datos oficial CIMA ",
                                                                            "y el nomenclátor del Ministerio. Mantén tu catálogo actualizado sin esfuerzo, ",
                                                                            "con información completa de precios, genéricos y laboratorios.",
                                                                        ],
                                                                        className="card-text",
                                                                        style={"lineHeight": "1.7", "color": "#6c757d"},
                                                                    ),
                                                                ],
                                                                className="text-center",
                                                            )
                                                        ],
                                                        style={"padding": "2rem"},
                                                    )
                                                ],
                                                className="h-100 shadow-sm",
                                                style={"borderRadius": "10px", "border": "none"},
                                            )
                                        ],
                                        width=12,
                                        md=6,
                                        lg=4,
                                        className="mb-4",
                                    ),
                                    # Feature 3: Insights y Recomendaciones
                                    dbc.Col(
                                        [
                                            dbc.Card(
                                                [
                                                    dbc.CardBody(
                                                        [
                                                            html.Div(
                                                                [
                                                                    html.I(
                                                                        className="fas fa-lightbulb fa-3x mb-3",
                                                                        style={"color": "#ffc107"},
                                                                    ),
                                                                    html.H4(
                                                                        "Insights y Recomendaciones",
                                                                        className="card-title mb-3",
                                                                        style={"fontWeight": "600"},
                                                                    ),
                                                                    html.P(
                                                                        [
                                                                            "Recibe recomendaciones personalizadas para optimizar tu inventario, ",
                                                                            "aumentar la rentabilidad y mejorar el servicio al cliente. ",
                                                                            "Análisis de genéricos, oportunidades de cross-selling y más.",
                                                                        ],
                                                                        className="card-text",
                                                                        style={"lineHeight": "1.7", "color": "#6c757d"},
                                                                    ),
                                                                ],
                                                                className="text-center",
                                                            )
                                                        ],
                                                        style={"padding": "2rem"},
                                                    )
                                                ],
                                                className="h-100 shadow-sm",
                                                style={"borderRadius": "10px", "border": "none"},
                                            )
                                        ],
                                        width=12,
                                        md=6,
                                        lg=4,
                                        className="mb-4",
                                    ),
                                ],
                                className="justify-content-center",
                            ),
                        ],
                        style={"maxWidth": "1400px"},
                    )
                ],
                style={"backgroundColor": "#f8f9fa", "padding": "5rem 0", "borderTop": "1px solid #dee2e6"},
            ),
            # Footer
            html.Footer(
                [
                    dbc.Container(
                        [
                            dbc.Row(
                                [
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.H5("kaiFarma", className="text-primary fw-bold mb-2"),
                                                    html.P(
                                                        "El valor del momento exacto",
                                                        className="text-muted mb-0",
                                                        style={"fontSize": "0.9rem"},
                                                    ),
                                                ]
                                            )
                                        ],
                                        width=12,
                                        md=6,
                                        className="mb-3 mb-md-0 text-center text-md-start",
                                    ),
                                    dbc.Col(
                                        [
                                            html.Div(
                                                [
                                                    html.P(
                                                        [
                                                            "© 2026 kaiFarma. ",
                                                            html.Span(
                                                                "Todos los derechos reservados.", className="text-muted"
                                                            ),
                                                        ],
                                                        className="mb-0",
                                                        style={"fontSize": "0.9rem"},
                                                    )
                                                ],
                                                className="text-center text-md-end",
                                            )
                                        ],
                                        width=12,
                                        md=6,
                                    ),
                                ]
                            )
                        ],
                        style={"maxWidth": "1400px"},
                    )
                ],
                style={"backgroundColor": "white", "borderTop": "1px solid #dee2e6", "padding": "2rem 0"},
            ),
        ],
        style={"overflowX": "hidden"},
    )
