# frontend/constants.py
"""
Constantes globales del frontend de xFarma.
Rutas, colores, configuraciones compartidas entre módulos.
"""

# =============================================================================
# RUTAS Y NAVEGACIÓN
# =============================================================================

# Rutas públicas (no requieren autenticación)
# NOTA: /auth/register está deshabilitado (redirige a landing) pero se mantiene
# en PUBLIC_ROUTES para evitar errores de autenticación antes del redirect
PUBLIC_ROUTES = [
    "/",
    "/login",  # Alias de /auth/login (backward compatibility)
    "/auth/login",
    "/auth/register",  # Deshabilitado - redirige a landing
    "/auth/forgot-password",
    "/auth/callback",
    "/auth/error",
    "/test-design-system",  # Página de prueba del Design System (desarrollo)
]

# Rutas protegidas
PROTECTED_ROUTES = {
    "HOME": "/home",
    "DASHBOARD": "/dashboard",
    "UPLOAD": "/upload",
    "CONFIG": "/config",
    "GENERICS": "/generics",
    "ADMIN": "/admin",
    "LABORATORY_MAPPING": "/laboratory-mapping",
}

# Rutas de redirección
REDIRECT_AFTER_LOGIN = "/home"
REDIRECT_AFTER_LOGOUT = "/"
REDIRECT_UNAUTHENTICATED = "/"

# =============================================================================
# COLORES Y ESTILOS
# =============================================================================

# Gradiente principal (landing page)
PRIMARY_GRADIENT = "linear-gradient(135deg, #0d6efd 0%, #0a58ca 50%, #084298 100%)"

# Colores de Bootstrap
COLORS = {
    "primary": "#0d6efd",
    "primary_dark": "#0a58ca",
    "primary_darker": "#084298",
    "success": "#28a745",
    "warning": "#ffc107",
    "danger": "#dc3545",
    "info": "#17a2b8",
    "light": "#f8f9fa",
    "dark": "#343a40",
    "muted": "#6c757d",
}

# Colores para features (landing page)
FEATURE_COLORS = {"analytics": "#0d6efd", "integration": "#28a745", "insights": "#ffc107"}  # Azul  # Verde  # Amarillo

# =============================================================================
# CONFIGURACIÓN DE LAYOUT
# =============================================================================

# Sidebar
SIDEBAR_WIDTH = "280px"
SIDEBAR_BG_COLOR = "#343a40"

# Top bar decorativa
TOP_BAR_HEIGHT = "4px"
TOP_BAR_GRADIENT = "linear-gradient(90deg, #007bff, #28a745)"

# Contenido principal
MAIN_CONTENT_PADDING = "2rem"
MAIN_CONTENT_PADDING_TOP = "3rem"

# =============================================================================
# RESPONSIVE BREAKPOINTS (Bootstrap)
# =============================================================================

BREAKPOINTS = {
    "xs": 0,  # <576px (móvil)
    "sm": 576,  # ≥576px (móvil grande)
    "md": 768,  # ≥768px (tablet)
    "lg": 992,  # ≥992px (desktop)
    "xl": 1200,  # ≥1200px (desktop grande)
    "xxl": 1400,  # ≥1400px (desktop ultra)
}

# Testing breakpoints
TEST_BREAKPOINTS = {"mobile": 375, "tablet": 768, "desktop": 1440}

# =============================================================================
# TIMEOUTS Y POLLING
# =============================================================================

# Intervalos de actualización (en milisegundos)
INTERVALS = {
    "fast": 1000,  # 1 segundo
    "normal": 5000,  # 5 segundos
    "slow": 30000,  # 30 segundos
    "very_slow": 60000,  # 1 minuto
}

# Timeouts de API (en segundos)
API_TIMEOUTS = {"short": 10, "normal": 30, "long": 60, "very_long": 120}

# =============================================================================
# MENSAJES Y TEXTOS
# =============================================================================

# Mensajes de error comunes
ERROR_MESSAGES = {
    "network": "Error de conexión con el servidor",
    "auth": "Error de autenticación",
    "validation": "Por favor verifica los datos ingresados",
    "generic": "Ha ocurrido un error inesperado",
}

# Mensajes de éxito comunes
SUCCESS_MESSAGES = {
    "login": "Inicio de sesión exitoso",
    "logout": "Sesión cerrada correctamente",
    "upload": "Archivo subido correctamente",
    "save": "Cambios guardados correctamente",
}

# =============================================================================
# CONFIGURACIÓN DE COMPONENTES
# =============================================================================

# Card styles
CARD_SHADOW = "shadow-sm"
CARD_SHADOW_LG = "shadow-lg"
CARD_BORDER_RADIUS = "10px"
CARD_BORDER_RADIUS_LG = "12px"

# Button styles
BUTTON_BORDER_RADIUS = "6px"
BUTTON_PADDING = "12px"

# Input styles
INPUT_BORDER_RADIUS = "6px"
INPUT_PADDING = "12px 16px"
INPUT_FONT_SIZE = "16px"

# =============================================================================
# FEATURE FLAGS
# =============================================================================

# Flags para control de funcionalidades
FEATURE_FLAGS = {
    "oauth_enabled": False,  # OAuth login (Google/Microsoft)
    "registration_enabled": False,  # Auto-registro de usuarios
    "catalog_sync_enabled": True,  # Sincronización CIMA
    "advanced_analytics": True,  # Analytics avanzado
    "export_enabled": True,  # Exportación de datos
}
