"""
Componentes para Dashboard Venta Libre (Issue #461, #471, #491, #494, #514)

Exports:
- Tab Análisis:
  - create_necesidad_treemap: Treemap de ventas por NECESIDAD
  - create_productos_table: Tabla de productos con feedback
  - create_evolution_chart: Gráfico evolución temporal (Issue #491)
  - create_yoy_table: Tabla comparación YoY (Issue #491)
  - create_top_contributors_table: Tabla top productos (Issue #491)

- Tab Producto y Surtido (Issue #494):
  - create_product_search: Buscador con autocompletado
  - create_product_ficha: Ficha producto con info básica
  - create_product_kpis: KPI cards (MAT, GMROI, Cobertura, Margen)
  - create_alternatives_table: Tabla alternativas (switching)
  - create_complementary_table: Tabla complementarios (MBA)
  - create_competitive_scatter: Scatter plot competitivo
  - create_decision_box: Semáforo de recomendación

Nota: Tab Gestión eliminado (Issue #488) - funcionalidades movidas a /admin.
"""

from components.ventalibre.necesidad_treemap import create_necesidad_treemap
from components.ventalibre.productos_table import create_productos_table
from components.ventalibre.evolution_chart import create_evolution_chart
from components.ventalibre.yoy_table import create_yoy_table
from components.ventalibre.top_contributors import create_top_contributors_table

# Issue #494: Tab Producto y Surtido
from components.ventalibre.product_search import create_product_search, format_search_option
from components.ventalibre.product_ficha import (
    create_product_ficha,
    create_product_kpis,
    create_product_ficha_placeholder,
    create_kpis_placeholder,
)
from components.ventalibre.alternatives_table import (
    create_alternatives_table,
    create_alternatives_placeholder,
)
from components.ventalibre.complementary_table import (
    create_complementary_table,
    create_complementary_placeholder,
)
from components.ventalibre.competitive_scatter import (
    create_competitive_scatter,
    create_scatter_placeholder,
)
from components.ventalibre.decision_box import (
    create_decision_box,
    create_decision_placeholder,
)

# Issue #505: L2 Drill-Down
from components.ventalibre.l2_drilldown import (
    create_l2_drilldown_modal,
    create_l2_treemap,
    create_l2_coverage_badge,
    create_l2_archetype_legend,
    create_l2_badge_for_l1,
)
from components.ventalibre.l2_value_quadrant import (
    create_l2_value_quadrant,
)

# Issue #505: L2 Categories from categories.py
from components.ventalibre.categories import (
    L1_WITH_L2,
    L2_CATEGORIES,
    L1_TO_L2,
    has_l2_subcategories,
    get_l2_for_l1,
    get_l2_info,
)

# Issue #514: ROI Tracker Widget
from components.ventalibre.roi_tracker_card import create_roi_tracker_card

# Issue #512: Context Menu Navigation
from components.ventalibre.context_menu import (
    create_context_menu_modal,
    create_context_category_badge,
)

__all__ = [
    # Tab Análisis
    "create_necesidad_treemap",
    "create_productos_table",
    "create_evolution_chart",
    "create_yoy_table",
    "create_top_contributors_table",
    # Tab Producto y Surtido (Issue #494)
    "create_product_search",
    "format_search_option",
    "create_product_ficha",
    "create_product_kpis",
    "create_product_ficha_placeholder",
    "create_kpis_placeholder",
    "create_alternatives_table",
    "create_alternatives_placeholder",
    "create_complementary_table",
    "create_complementary_placeholder",
    "create_competitive_scatter",
    "create_scatter_placeholder",
    "create_decision_box",
    "create_decision_placeholder",
    # Issue #505: L2 Drill-Down
    "create_l2_drilldown_modal",
    "create_l2_treemap",
    "create_l2_coverage_badge",
    "create_l2_archetype_legend",
    "create_l2_badge_for_l1",
    "create_l2_value_quadrant",
    "L1_WITH_L2",
    "L2_CATEGORIES",
    "L1_TO_L2",
    "has_l2_subcategories",
    "get_l2_for_l1",
    "get_l2_info",
    # Issue #514: ROI Tracker
    "create_roi_tracker_card",
    # Issue #512: Context Menu Navigation
    "create_context_menu_modal",
    "create_context_category_badge",
]
