"""
Banner de estado del sistema para transparencia de inicialización
Solución unificada para Issues #12 y #14
"""

import dash_bootstrap_components as dbc
from dash import dcc, html


def create_system_status_banner() -> dbc.Container:
    """
    Crea el banner de estado del sistema que se muestra en la parte superior
    """
    return dbc.Container(
        [
            # Banner container más discreto
            html.Div(
                id="system-status-banner",
                style={
                    "display": "none",
                    "position": "absolute",  # Absolute para posicionar debajo de la franja azul
                    "top": "4px",  # Justo debajo de la franja azul de 4px
                    "left": "0",
                    "right": "0",
                    "zIndex": "1020",
                },
                children=[
                    html.Div(
                        id="system-status-alert",
                        className="px-3 py-2 border-bottom",
                        style={"backgroundColor": "#fff3cd", "fontSize": "0.875rem"},
                        children=[
                            html.Div(
                                [
                                    html.I(className="bi bi-info-circle me-2"),
                                    html.Span("Verificando estado del sistema...", id="status-message"),
                                    html.Div(
                                        dbc.Progress(
                                            id="system-progress-bar",
                                            value=0,
                                            striped=True,
                                            animated=True,
                                            className="ms-3",
                                            style={"height": "4px", "width": "100px"},
                                        ),
                                        className="d-inline-block align-middle",
                                    ),
                                ],
                                className="d-flex align-items-center justify-content-center",
                            )
                        ],
                    )
                ],
            ),
            # Store para guardar el estado
            dcc.Store(id="system-status-store"),
            # Interval para actualización periódica
            dcc.Interval(
                id="system-status-interval",
                interval=30000,  # Actualizar cada 30 segundos (reducido para evitar sobrecarga)
                n_intervals=0,
            ),
        ],
        fluid=True,
        className="p-0",
    )


# NOTA: Los callbacks están registrados en callbacks/common.py


def create_onboarding_page() -> dbc.Container:
    """
    Página de onboarding para primera ejecución del sistema
    """
    return dbc.Container(
        [
            dbc.Row(
                [
                    dbc.Col(
                        [
                            html.Div(
                                [
                                    html.H1("Bienvenido a xFarma", className="text-center mb-4"),
                                    html.P(
                                        "Sistema de gestión y análisis farmacéutico",
                                        className="text-center text-muted mb-5",
                                    ),
                                    dbc.Card(
                                        [
                                            dbc.CardBody(
                                                [
                                                    html.H4("Preparando tu sistema por primera vez", className="mb-4"),
                                                    html.P(
                                                        "Estamos descargando y procesando los datos necesarios para que "
                                                        "puedas comenzar a usar xFarma. Este proceso solo se ejecuta una vez.",
                                                        className="text-muted",
                                                    ),
                                                    html.Div(
                                                        [
                                                            dbc.Checklist(
                                                                id="initialization-checklist",
                                                                options=[
                                                                    {
                                                                        "label": " Descargando catálogo de medicamentos",
                                                                        "value": "catalog",
                                                                        "disabled": True,
                                                                    },
                                                                    {
                                                                        "label": " Sincronizando datos del Nomenclátor",
                                                                        "value": "nomenclator",
                                                                        "disabled": True,
                                                                    },
                                                                    {
                                                                        "label": " Enriqueciendo con datos CIMA",
                                                                        "value": "cima",
                                                                        "disabled": True,
                                                                    },
                                                                    {
                                                                        "label": " Calculando grupos homogéneos",
                                                                        "value": "groups",
                                                                        "disabled": True,
                                                                    },
                                                                ],
                                                                value=[],  # Se actualizará dinámicamente
                                                                className="mb-4",
                                                            )
                                                        ]
                                                    ),
                                                    dbc.Progress(
                                                        id="onboarding-progress",
                                                        value=0,
                                                        striped=True,
                                                        animated=True,
                                                        className="mb-3",
                                                        style={"height": "25px"},
                                                    ),
                                                    html.Div(
                                                        id="onboarding-status-message",
                                                        className="text-center text-muted",
                                                        children="Iniciando proceso...",
                                                    ),
                                                    dbc.Alert(
                                                        html.Div([
                                                            html.I(className="bi bi-info-circle-fill me-2"),
                                                            "Este proceso puede tomar entre 3 y 5 minutos. "
                                                            "Por favor, no cierres esta ventana.",
                                                        ]),
                                                        color="info",
                                                        className="mt-4",
                                                    ),
                                                ]
                                            )
                                        ]
                                    ),
                                ]
                            )
                        ],
                        width={"size": 8, "offset": 2},
                    )
                ],
                className="mt-5",
            )
        ],
        fluid=True,
    )
