# frontend/components/proactive_alerts/__init__.py
"""
ProactiveAlerts Components - Alertas proactivas Dashboard (Pivot 2026)

Componentes "dumb" que leen del global-alerts-store y renderizan
sin logica de negocio.

Arquitectura: "Smart Store, Dumb Component"
- AlertsGrid lee del store y ordena por severidad
- AlertCard renderiza una alerta individual
- EmptyState muestra estado gratificante cuando no hay alertas

Components:
- AlertCard: Card individual con icono, count, value, msg, action
- AlertsGrid: Grid responsive 2x2 ordenado por severidad
- EmptyState: Estado vacio con check verde

CSS (para inyectar en assets/style.css):
- ALERTS_GRID_CSS: Animaciones de entrada para cards
- EMPTY_STATE_CSS: Animacion bounce del check

Usage:
    from components.proactive_alerts import AlertsGrid, AlertCard, EmptyState

    # En callback
    @app.callback(
        Output('alerts-container', 'children'),
        Input('global-alerts-store', 'data')
    )
    def render_alerts(alerts_data):
        return AlertsGrid(alerts_data)

See: #602 ProactiveAlerts Component
See: #599 Epic: Dashboard Operativo Pivot 2026
"""

from .alert_card import AlertCard, SEVERITY_CONFIG
from .alerts_grid import AlertsGrid, ALERTS_GRID_CSS, SEVERITY_ORDER
from .empty_state import EmptyState, EMPTY_STATE_CSS


# CSS combinado para inyectar en assets
PROACTIVE_ALERTS_CSS = f"""
{ALERTS_GRID_CSS}

{EMPTY_STATE_CSS}
"""


__all__ = [
    # Components
    "AlertCard",
    "AlertsGrid",
    "EmptyState",
    # Configuration
    "SEVERITY_CONFIG",
    "SEVERITY_ORDER",
    # CSS
    "ALERTS_GRID_CSS",
    "EMPTY_STATE_CSS",
    "PROACTIVE_ALERTS_CSS",
]
