"""
Componentes de visualización para dashboard de prescripción.

Issue #400 - Sprint 3: Visualizaciones
Issue #489 - Tab 3: Seasonality (heatmap, monthly index)
Issue #498 - STL Decomposition + Forecast
Issue #532 - ATC filter replaces category patterns UI
"""

from .prescription_evolution import create_prescription_evolution_chart
from .atc_distribution_treemap import create_atc_treemap
from .waterfall_analysis import create_waterfall_chart
from .heatmap_hourly import (
    create_hourly_heatmap_chart,
    create_heatmap_container,
    create_peak_info_text,
)
from .monthly_index_chart import (
    create_monthly_index_chart,
    create_monthly_index_container,
    create_data_quality_alert,
)
from .trend_decomposition_chart import (
    create_decomposition_chart,
    create_decomposition_container,
    create_decomposition_summary_card,
    create_forecast_chart,
    create_forecast_container,
    create_forecast_summary_card,
    create_data_quality_alert_stl,
)
# Issue #532: category_patterns_chart exports removed - UI replaced by ATC filter
# Backend endpoint still exists for internal use (badges, comprehensive analysis)

__all__ = [
    "create_prescription_evolution_chart",
    "create_atc_treemap",
    "create_waterfall_chart",
    # Issue #489: Seasonality components
    "create_hourly_heatmap_chart",
    "create_heatmap_container",
    "create_peak_info_text",
    "create_monthly_index_chart",
    "create_monthly_index_container",
    "create_data_quality_alert",
    # Issue #498: STL + Forecast components
    "create_decomposition_chart",
    "create_decomposition_container",
    "create_decomposition_summary_card",
    "create_forecast_chart",
    "create_forecast_container",
    "create_forecast_summary_card",
    "create_data_quality_alert_stl",
    # Issue #532: Category patterns UI removed - replaced by ATC filter
]
