# frontend/components/inventory/__init__.py
"""
Componentes reutilizables para análisis de inventario.

Issue #471: Componentes para pestañas de Inventario en /prescription y /ventalibre.
Consumen medidas del backend via measures API (REGLA #19).
"""

from .abc_chart import create_abc_treemap
from .kpi_cards import create_inventory_kpis
from .rotation_table import create_rotation_table
from .tab_layout import create_inventory_tab, create_inventory_tab_placeholder

__all__ = [
    "create_inventory_kpis",
    "create_abc_treemap",
    "create_rotation_table",
    "create_inventory_tab",
    "create_inventory_tab_placeholder",
]
