# frontend/components/generics/__init__.py
"""
Generics analysis components package.

This package contains UI components for the generics analysis panel,
extracted from frontend/callbacks/generics.py for better organization.

Modules:
- matrix: PowerBI-style matrix components
- tables: Table and row components
- charts: Chart visualization components
"""

# Matrix components
from .matrix import (
    create_matrix_detail_content,
    create_matrix_group_row,
    create_powerbi_matrix,
)

# Table components
from .tables import (
    create_partner_refs_table,
    create_presentation_item,
    create_product_row,
    create_product_row_with_bar,
    create_products_detail_table,
    create_traditional_table,
)

# Chart components
from .charts import create_empty_chart, create_stacked_bar_chart

__all__ = [
    # Matrix
    "create_powerbi_matrix",
    "create_matrix_group_row",
    "create_matrix_detail_content",
    # Tables
    "create_products_detail_table",
    "create_product_row_with_bar",
    "create_product_row",
    "create_presentation_item",
    "create_traditional_table",
    "create_partner_refs_table",
    # Charts
    "create_stacked_bar_chart",
    "create_empty_chart",
]
