// Script JavaScript para formatear tooltip del RangeSlider con fechas
// Se incluye en el componente generic_analysis.py

// Función global para formatear tooltip de fechas
window.formatDateTooltip = function(value) {
    try {
        // Convertir días desde época a fecha
        const epochDate = new Date(1970, 0, 1);
        const targetDate = new Date(epochDate.getTime() + (value * 24 * 60 * 60 * 1000));

        // Formatear como DD/MM/YYYY
        const day = String(targetDate.getDate()).padStart(2, '0');
        const month = String(targetDate.getMonth() + 1).padStart(2, '0');
        const year = targetDate.getFullYear();

        return day + '/' + month + '/' + year;
    } catch (e) {
        return value.toString();
    }
};
