"""
Componente reutilizable de selector de rango de fechas.
Usado en /generics, /ventalibre, /prescription para filtrado temporal.
"""

from datetime import datetime, timedelta
from dash import dcc
import dash_bootstrap_components as dbc
from components.base import Title


def DateRangeFilter(id_prefix: str, default_days: int = 365):
    """
    Crea un selector de rango de fechas con valores por defecto.

    Args:
        id_prefix: Prefijo para los IDs (ej: "generics", "ventalibre")
        default_days: Días hacia atrás desde hoy (default: 365)

    Returns:
        dbc.Col con el componente de fecha

    Example:
        DateRangeFilter("generics", default_days=180)
        # Genera IDs: "generics-date-range"
    """
    end_date = datetime.now().date()
    start_date = (datetime.now() - timedelta(days=default_days)).date()

    return dbc.Col([
        Title("📅 Período de Análisis", level=6, className="mb-2"),
        dcc.DatePickerRange(
            id=f"{id_prefix}-date-range",
            start_date=start_date,
            end_date=end_date,
            display_format="DD/MM/YYYY",
            start_date_placeholder_text="Desde",
            end_date_placeholder_text="Hasta",
            calendar_orientation="horizontal",
            first_day_of_week=1,  # Lunes
            month_format="MMMM YYYY",
            className="w-100",
            style={"width": "100%"},
            clearable=False,
            persistence=True,
            persistence_type="session",
        )
    ], lg=4, md=6, sm=12, className="mb-3 mb-lg-0")
