"""
Componente reutilizable de botón "Aplicar Filtros".
Estándar para todas las páginas de análisis.
"""

from dash import html
import dash_bootstrap_components as dbc
from components.base import BaseButton


def ApplyButton(id_prefix: str, label: str = "Aplicar Filtros"):
    """
    Crea un botón estándar para aplicar filtros.

    Args:
        id_prefix: Prefijo para el ID (ej: "generics", "ventalibre")
        label: Texto del botón (default: "Aplicar Filtros")

    Returns:
        dbc.Col con el botón de aplicación

    Example:
        ApplyButton("generics", label="Actualizar Análisis")
        # Genera ID: "generics-apply-btn"
    """
    return dbc.Col([
        # Label invisible para alineación con otros filtros
        html.Div(
            html.Span("\u00A0", className="d-block mb-2"),  # Espacio no-rompible
            style={"height": "28px"}  # Altura aprox. de Title level=6
        ),
        BaseButton(
            [
                html.I(className="fas fa-check me-2"),
                label
            ],
            id=f"{id_prefix}-apply-btn",
            variant="primary",
            size="md",
            className="w-100",
            style={"height": "38px"}  # Altura consistente con dropdown
        ),
    ], lg=4, md=12, sm=12, className="d-flex align-items-end")
