"""
xFarma Design System - Base Components

Componentes base reutilizables que implementan el design system.
Estos componentes deben usarse como bloques de construcción para la UI.

Componentes disponibles:
- BaseCard: Contenedor con variantes y sombras
- BaseButton: Botones con variantes y tamaños
- Title: Títulos con jerarquía automática

Uso:
    from components.base import BaseCard, BaseButton, Title
"""

from .button import BaseButton
from .card import BaseCard
from .title import Title

__all__ = [
    "BaseCard",
    "BaseButton",
    "Title",
]
