# frontend/components/__init__.py
"""
Componentes reutilizables para la interfaz de xfarma.
Incluye KPIs, gráficos, navegación y elementos comunes.
"""

from .charts import create_bar_chart, create_line_chart, create_pie_chart
from .common import create_alert, create_loading_spinner, create_status_badge
from .kpi_cards import create_kpi_card, create_kpi_row
from .navigation import create_navbar, create_sidebar
from .upload import (
    create_file_upload_zone,
    create_upload_error_alert,
    create_upload_success_alert,
    create_validation_warnings,
)

__all__ = [
    # KPI Cards
    "create_kpi_card",
    "create_kpi_row",
    # Charts
    "create_line_chart",
    "create_pie_chart",
    "create_bar_chart",
    # Navigation
    "create_navbar",
    "create_sidebar",
    # Common
    "create_loading_spinner",
    "create_alert",
    "create_status_badge",
    # Upload
    "create_file_upload_zone",
    "create_upload_success_alert",
    "create_upload_error_alert",
    "create_validation_warnings",
]
