# frontend/callbacks/inventory/__init__.py
"""
Callbacks reutilizables para pestañas de Inventario (Issue #471).

Consumen medidas del backend:
- stock_value, dead_stock_value, stock_coverage_days, stock_alerts
- rotation_index, days_inventory, abc_classification
- roi_product, gmroi, contribution_margin

Se usan en /prescription (medicamento) y /ventalibre (venta_libre).
"""

from callbacks.inventory.abc import register_inventory_abc_callbacks
from callbacks.inventory.alerts import register_inventory_alerts_callbacks
from callbacks.inventory.coverage import register_inventory_coverage_callbacks
from callbacks.inventory.kpis import register_inventory_kpis_callbacks
from callbacks.inventory.table import register_inventory_table_callbacks


def register_inventory_callbacks(app):
    """
    Registrar todos los callbacks de inventario.

    Args:
        app: Instancia de la aplicación Dash
    """
    register_inventory_kpis_callbacks(app)
    register_inventory_abc_callbacks(app)
    register_inventory_table_callbacks(app)
    register_inventory_alerts_callbacks(app)
    register_inventory_coverage_callbacks(app)  # Issue #496: Gráfico de cobertura


__all__ = ["register_inventory_callbacks"]
