# frontend/callbacks/insights/__init__.py
"""
Insight Engine Callbacks - Issue #506

Callbacks para carga de datos y gestión de feedback de insights.

Uso:
    from callbacks.insights import register_insights_callbacks

    register_insights_callbacks(app)
"""

from .data_loading import register_insights_data_callbacks
from .feedback import register_insights_feedback_callbacks


def register_insights_callbacks(app):
    """Registra todos los callbacks de insights."""
    register_insights_data_callbacks(app)
    register_insights_feedback_callbacks(app)


__all__ = [
    "register_insights_callbacks",
    "register_insights_data_callbacks",
    "register_insights_feedback_callbacks",
]
