# frontend/callbacks/encargos/__init__.py
"""
Cazador de Encargos - Callbacks

Register all callbacks for the customer order tracking module.
"""

from callbacks.encargos.data_loading import register_encargos_data_callbacks
from callbacks.encargos.actions import register_encargos_action_callbacks


def register_encargos_callbacks(app):
    """
    Register all encargos module callbacks.

    Args:
        app: Dash application instance
    """
    register_encargos_data_callbacks(app)
    register_encargos_action_callbacks(app)


__all__ = [
    "register_encargos_callbacks",
    "register_encargos_data_callbacks",
    "register_encargos_action_callbacks",
]
