-- Script de Verificación: Índice Optimizado para Pharmacy Partners
-- Migración: 93bb5550e341_optimize_pharmacy_partners_index_for_sorted_queries
-- Fecha: 2025-11-08

-- 1. Verificar que el índice existe
SELECT
    schemaname,
    tablename,
    indexname,
    indexdef
FROM pg_indexes
WHERE tablename = 'pharmacy_partners'
    AND indexname = 'ix_pharmacy_partners_pharmacy_id_sorted';

-- 2. Ver todos los índices de la tabla
\d+ pharmacy_partners

-- 3. Verificar el tamaño del índice
SELECT
    schemaname,
    tablename,
    indexname,
    pg_size_pretty(pg_relation_size(indexrelid)) AS index_size
FROM pg_stat_user_indexes
WHERE tablename = 'pharmacy_partners'
ORDER BY indexname;

-- 4. Verificar uso del índice (con tabla pequeña, puede preferir Seq Scan)
EXPLAIN (ANALYZE, BUFFERS)
SELECT id, pharmacy_id, laboratory_name, is_selected, is_auto_suggested
FROM pharmacy_partners
WHERE pharmacy_id = (SELECT id FROM pharmacies LIMIT 1)
ORDER BY is_selected DESC, is_auto_suggested DESC, laboratory_name
LIMIT 100;

-- 5. Forzar uso del índice para verificar que funciona
SET enable_seqscan = off;
EXPLAIN (ANALYZE, BUFFERS)
SELECT id, pharmacy_id, laboratory_name, is_selected, is_auto_suggested
FROM pharmacy_partners
WHERE pharmacy_id = (SELECT id FROM pharmacies LIMIT 1)
ORDER BY is_selected DESC, is_auto_suggested DESC, laboratory_name
LIMIT 100;
SET enable_seqscan = on;

-- 6. Estadísticas del índice
SELECT
    schemaname,
    tablename,
    indexname,
    idx_scan as "Index Scans",
    idx_tup_read as "Tuples Read",
    idx_tup_fetch as "Tuples Fetched"
FROM pg_stat_user_indexes
WHERE tablename = 'pharmacy_partners'
ORDER BY indexname;
