import sys

sys.path.append("/app")
from sqlalchemy import desc, func

from app.database import SessionLocal
from app.models import ProductCatalog, SalesData

db = SessionLocal()

# Top 10 productos más vendidos por cantidad
top_products = (
    db.query(
        SalesData.codigo_nacional,
        SalesData.product_name,
        func.sum(SalesData.quantity).label("total_quantity"),
        func.sum(SalesData.total_amount).label("total_sales"),
        func.count(SalesData.id).label("num_transactions"),
    )
    .filter(SalesData.pharmacy_id == "11111111-1111-1111-1111-111111111111")
    .group_by(SalesData.codigo_nacional, SalesData.product_name)
    .order_by(desc("total_quantity"))
    .limit(10)
    .all()
)

print("TOP 10 PRODUCTOS MÁS VENDIDOS CON INFORMACIÓN COMPLETA DE ENRIQUECIMIENTO")
print("=" * 100)

for idx, prod in enumerate(top_products, 1):
    print(f"\n{idx}. {prod.product_name}")
    print(f'   Código Nacional: {prod.codigo_nacional or "SIN CN"}')
    print(f"   Cantidad vendida: {prod.total_quantity:.0f} unidades")
    print(f"   Ventas totales: €{prod.total_sales:.2f}")
    print(f"   Transacciones: {prod.num_transactions}")

    # Buscar en el catálogo
    if prod.codigo_nacional:
        catalog = db.query(ProductCatalog).filter(ProductCatalog.national_code == prod.codigo_nacional).first()

        if catalog:
            print("   --- ✅ PRODUCTO ENRIQUECIDO ---")
            print(f'   Nombre Nomenclátor: {catalog.nomen_nombre or "N/A"}')
            print(f'   Laboratorio (Nomen): {catalog.nomen_laboratorio or "N/A"}')
            print(f'   Tipo Fármaco: {catalog.nomen_tipo_farmaco or "N/A"}')
            print(f'   Principio Activo: {catalog.nomen_principio_activo or "N/A"}')
            if catalog.nomen_pvp:
                print(f"   PVP Nomenclátor: €{catalog.nomen_pvp:.2f}")
            if catalog.nomen_pvl_calculado:
                print(f"   PVL Calculado: €{catalog.nomen_pvl_calculado:.2f}")
            print(f'   Estado Nomenclátor: {catalog.nomen_estado or "N/A"}')
            print("   --- DATOS CIMA ---")
            print(f'   Nombre Comercial: {catalog.cima_nombre_comercial or "N/A"}')
            print(f'   Lab Titular CIMA: {catalog.cima_laboratorio_titular or "N/A"}')
            print(f'   Grupo Terapéutico: {catalog.cima_grupo_terapeutico or "N/A"}')
            print(
                f'   Es Genérico CIMA: {"SÍ" if catalog.cima_es_generico else "NO" if catalog.cima_es_generico is not None else "N/A"}'
            )
            print(
                f'   Requiere Receta: {"SÍ" if catalog.cima_requiere_receta else "NO" if catalog.cima_requiere_receta is not None else "N/A"}'
            )
            print(f"   Fuentes de Datos: {catalog.data_sources}")
            print(f"   Estado Sync: {catalog.sync_status}")
            print(f'   Confianza Enriquecimiento: {catalog.enrichment_confidence or "N/A"}%')
        else:
            print("   ⚠️ PRODUCTO NO ENCONTRADO EN CATÁLOGO")
            # Podría ser un producto de parafarmacia o servicio sin CN válido
    else:
        print("   ❌ SIN CÓDIGO NACIONAL - NO SE PUEDE ENRIQUECER")

db.close()
