import sys

sys.path.append("/app")

from sqlalchemy import desc, func

from app.database import SessionLocal
from app.models import ProductCatalog, SalesData

db = SessionLocal()

# Top 5 productos más vendidos para ver TODO el detalle
top_products = (
    db.query(
        SalesData.codigo_nacional,
        SalesData.product_name,
        func.sum(SalesData.quantity).label("total_quantity"),
        func.sum(SalesData.total_amount).label("total_sales"),
    )
    .filter(
        SalesData.pharmacy_id == "11111111-1111-1111-1111-111111111111",
        SalesData.codigo_nacional.isnot(None),
        SalesData.codigo_nacional != "",
    )
    .group_by(SalesData.codigo_nacional, SalesData.product_name)
    .order_by(desc("total_quantity"))
    .limit(5)
    .all()
)

print("=" * 120)
print("ANÁLISIS COMPLETO DE ENRIQUECIMIENTO - TOP 5 PRODUCTOS MÁS VENDIDOS")
print("=" * 120)

for idx, prod in enumerate(top_products, 1):
    print(f'\n{"="*120}')
    print(f"{idx}. {prod.product_name}")
    print(
        f"   CN: {prod.codigo_nacional} | Vendido: {prod.total_quantity:.0f} unidades | Total: €{prod.total_sales:.2f}"
    )
    print("=" * 120)

    catalog = db.query(ProductCatalog).filter(ProductCatalog.national_code == prod.codigo_nacional).first()

    if catalog:
        print("\n📊 CAMPOS DEL NOMENCLÁTOR (nomen_*):")
        print(f"   nomen_nombre: {catalog.nomen_nombre}")
        print(f"   nomen_laboratorio: {catalog.nomen_laboratorio}")
        print(f"   nomen_tipo_farmaco: {catalog.nomen_tipo_farmaco}")
        print(f"   nomen_principio_activo: {catalog.nomen_principio_activo}")
        print(f"   nomen_pvp: {catalog.nomen_pvp}")
        print(f"   nomen_precio_referencia: {catalog.nomen_precio_referencia}")
        print(f"   nomen_aportacion_usuario: {catalog.nomen_aportacion_usuario}")
        print(f"   nomen_pvl_calculado: {catalog.nomen_pvl_calculado}")
        print(f"   nomen_codigo_homogeneo: {catalog.nomen_codigo_homogeneo}")
        print(f"   nomen_nombre_homogeneo: {catalog.nomen_nombre_homogeneo}")
        print(f"   nomen_estado: {catalog.nomen_estado}")
        print(f"   nomen_fecha_alta: {catalog.nomen_fecha_alta}")
        print(f"   nomen_fecha_baja: {catalog.nomen_fecha_baja}")

        print("\n💊 CAMPOS DE CIMA (cima_*):")
        print(f"   cima_vmp: {catalog.cima_vmp}")
        print(f"   cima_vmpp: {catalog.cima_vmpp}")
        print(f"   cima_nombre_comercial: {catalog.cima_nombre_comercial}")
        print(f"   cima_atc_codes: {catalog.cima_atc_codes}")
        print(f"   cima_atc_code: {catalog.cima_atc_code}")
        print(f"   cima_grupo_terapeutico: {catalog.cima_grupo_terapeutico}")
        print(f"   cima_principios_activos: {catalog.cima_principios_activos}")
        print(f"   cima_forma_farmaceutica: {catalog.cima_forma_farmaceutica}")
        print(f"   cima_via_administracion: {catalog.cima_via_administracion}")
        print(f"   cima_dosis: {catalog.cima_dosis}")
        print(f"   cima_laboratorio_titular: {catalog.cima_laboratorio_titular}")
        print(f"   cima_condiciones_prescripcion: {catalog.cima_condiciones_prescripcion}")
        print(f"   cima_estado_registro: {catalog.cima_estado_registro}")
        print(f"   cima_requiere_receta: {catalog.cima_requiere_receta}")
        print(f"   cima_es_generico: {catalog.cima_es_generico}")
        print(f"   cima_uso_veterinario: {catalog.cima_uso_veterinario}")

        print("\n🔧 CAMPOS DE CONTROL:")
        print(f"   data_sources: {catalog.data_sources}")
        print(f"   enrichment_confidence: {catalog.enrichment_confidence}")
        print(f"   sync_status: {catalog.sync_status}")
        print(f"   created_at: {catalog.created_at}")
        print(f"   updated_at: {catalog.updated_at}")

        # Análisis de completitud
        print("\n📈 ANÁLISIS DE COMPLETITUD:")
        nomen_fields = [
            catalog.nomen_nombre,
            catalog.nomen_laboratorio,
            catalog.nomen_tipo_farmaco,
            catalog.nomen_principio_activo,
            catalog.nomen_pvp,
        ]
        cima_fields = [
            catalog.cima_nombre_comercial,
            catalog.cima_laboratorio_titular,
            catalog.cima_forma_farmaceutica,
            catalog.cima_via_administracion,
        ]

        nomen_complete = sum(1 for f in nomen_fields if f is not None)
        cima_complete = sum(1 for f in cima_fields if f is not None)

        print(f"   Campos Nomenclátor completos: {nomen_complete}/5 principales")
        print(f"   Campos CIMA completos: {cima_complete}/4 principales")
        print(f"   Fuentes de datos: {catalog.data_sources}")

        if "nomenclator" in catalog.data_sources and "cima" in catalog.data_sources:
            print("   ✅ PRODUCTO COMPLETAMENTE ENRIQUECIDO (Nomenclátor + CIMA)")
        elif "nomenclator" in catalog.data_sources:
            print("   ⚠️ ENRIQUECIDO SOLO CON NOMENCLÁTOR")
        elif "cima" in catalog.data_sources:
            print("   ⚠️ ENRIQUECIDO SOLO CON CIMA")
        else:
            print("   ❌ SIN FUENTES DE ENRIQUECIMIENTO")
    else:
        print("   ❌ PRODUCTO NO ENCONTRADO EN CATÁLOGO")

db.close()
