#!/usr/bin/env python3
"""Script para resetear password de usuario en Render production"""

from passlib.context import CryptContext

# Configurar contexto bcrypt
pwd_context = CryptContext(schemes=["bcrypt"], deprecated="auto")

# Password a establecer
new_password = "xFarma_Admin_2024!"

# Generar hash
hashed_password = pwd_context.hash(new_password)

# Output SQL UPDATE statement
print("-- SQL para actualizar password en Render")
print(f"UPDATE users SET hashed_password = '{hashed_password}' WHERE email = 'dgruiz@gmail.com';")
print()
print("-- Hash generado:")
print(hashed_password)
