-- Script para añadir columnas CIMA faltantes en product_catalog
-- Solo añade las columnas si no existen

DO $$
BEGIN
    -- cima_vmp
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_vmp') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_vmp VARCHAR(500);
    END IF;

    -- cima_vmpp
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_vmpp') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_vmpp VARCHAR(500);
    END IF;

    -- cima_atc_codes (JSONB)
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_atc_codes') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_atc_codes JSONB;
    END IF;

    -- cima_principios_activos (JSONB)
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_principios_activos') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_principios_activos JSONB;
    END IF;

    -- cima_condiciones_prescripcion
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_condiciones_prescripcion') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_condiciones_prescripcion VARCHAR(200);
    END IF;

    -- cima_estado_registro
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'cima_estado_registro') THEN
        ALTER TABLE product_catalog ADD COLUMN cima_estado_registro VARCHAR(50);
    END IF;

    -- sync_status
    IF NOT EXISTS (SELECT 1 FROM information_schema.columns
                   WHERE table_name = 'product_catalog' AND column_name = 'sync_status') THEN
        ALTER TABLE product_catalog ADD COLUMN sync_status VARCHAR(20);
    END IF;

    RAISE NOTICE 'Columnas CIMA verificadas/añadidas exitosamente';
END $$;

-- Crear índice para sync_status si no existe
CREATE INDEX IF NOT EXISTS ix_product_catalog_sync_status
ON product_catalog(sync_status);

-- Verificar columnas añadidas
SELECT column_name, data_type, character_maximum_length
FROM information_schema.columns
WHERE table_name = 'product_catalog'
AND column_name IN ('cima_vmp', 'cima_vmpp', 'cima_atc_codes',
                    'cima_principios_activos', 'cima_condiciones_prescripcion',
                    'cima_estado_registro', 'sync_status')
ORDER BY column_name;
