# PROTOCOLO OBLIGATORIO PARA GENERACIÓN DE CÓDIGO API

## ⚠️ REGLA ESTRICTA: NUNCA generar código de API sin consultar primero la documentación

### ANTES de escribir CUALQUIER código que llame a la API:

1. **SIEMPRE consultar primero** (en este orden):
   ```
   a) OpenAPI spec en vivo: curl http://localhost:8000/openapi.json
   b) Documentación local: frontend/docs/API_ENDPOINTS.md
   c) Tipos de datos: docs/DATA_CATALOG.md
   ```

2. **VERIFICAR específicamente**:
   - Ruta exacta del endpoint
   - Método HTTP (GET, POST, etc.)
   - Parámetros requeridos vs opcionales
   - Formato del body (JSON, multipart/form-data, etc.)
   - Headers necesarios
   - Formato de respuesta esperado

3. **COPIAR literalmente** del OpenAPI:
   - Nombres de campos exactos (no inventar)
   - Tipos de datos correctos
   - Valores de enum permitidos
   - Límites min/max

### EJEMPLO DE FLUJO CORRECTO:

```python
# MAL ❌ - Código inventado sin consultar
response = requests.post(
    f"{BACKEND_URL}/api/upload",  # Ruta inventada
    files={"file": file},  # Parámetros asumidos
)

# BIEN ✅ - Después de consultar OpenAPI
# Del OpenAPI spec veo que:
# - Ruta: /api/upload/ (con slash final!)
# - Body: multipart/form-data con campo "file"
# - Query params opcionales: pharmacy_id, erp_type
response = requests.post(
    f"{BACKEND_URL}/api/upload/",  # Ruta exacta del spec
    files={"file": (filename, file_content, content_type)},  # Formato correcto
    params={"pharmacy_id": pharmacy_id, "erp_type": erp_type}  # Params del spec
)
```

### RECORDATORIOS CRÍTICOS:

- **NUNCA asumir** nombres de campos o rutas
- **NUNCA usar** `/api/v1/` sin verificar (muchos endpoints no lo tienen)
- **SIEMPRE verificar** si el endpoint espera UUID o string
- **COPIAR exactamente** los nombres de campos del spec (no traducir)

### VALIDACIÓN:

Antes de ejecutar cualquier código con llamadas API:
1. ¿Consulté el OpenAPI spec para este endpoint?
2. ¿Copié los nombres de campos exactamente?
3. ¿Verifiqué el formato de respuesta esperado?

Si la respuesta a CUALQUIERA es NO → DETENER y consultar primero.
