# backend/app/services/insight_engine/rules/__init__.py
"""
Reglas del Insight Engine v2.0.

Issue #506: 10 reglas organizadas por categoría.

Stock (3):
- STOCK_001: Stock Crítico (Clase A con <3 días cobertura)
- STOCK_002: Sobrestock (Clase C con >180 días cobertura)
- STOCK_003: Caja Atrapada (capital en productos dead/slow)

Margin (2):
- MARGIN_001: Erosión de Margen (caída >3pp YoY)
- MARGIN_002: Margen Bajo (top sellers con <15% margen)

HHI (1):
- HHI_001: Dependencia Crítica (HHI >4000 en categoría)

Trend (1):
- TREND_001: Caída Sostenida (>15% caída 3+ meses consecutivos)

Surtido (3):
- SURTIDO_001: Desequilibrio (categoría con >5% ventas pero <3 SKUs)
- SURTIDO_002: Hueco de Surtido (mercado >30% pero farmacia <10%)
- SURTIDO_003: Canibalización (correlación negativa entre SKUs)
"""

from .base import BaseInsightRule
from .hhi_rules import DependenciaCriticaRule
from .margin_rules import ErosionMargenRule, MargenBajoRule
from .stock_rules import CajaAtrapadaRule, SobrestockRule, StockCriticoRule
from .surtido_rules import CanibalizacionRule, DesequilibrioRule, HuecoSurtidoRule
from .trend_rules import CaidaSostenidaRule

__all__ = [
    # Base
    "BaseInsightRule",
    # Stock rules
    "StockCriticoRule",
    "SobrestockRule",
    "CajaAtrapadaRule",
    # Margin rules
    "ErosionMargenRule",
    "MargenBajoRule",
    # HHI rules
    "DependenciaCriticaRule",
    # Trend rules
    "CaidaSostenidaRule",
    # Surtido rules
    "DesequilibrioRule",
    "HuecoSurtidoRule",
    "CanibalizacionRule",
]

# Ordered list of all rules for engine initialization
ALL_RULES = [
    StockCriticoRule,
    SobrestockRule,
    CajaAtrapadaRule,
    ErosionMargenRule,
    MargenBajoRule,
    DependenciaCriticaRule,
    CaidaSostenidaRule,
    DesequilibrioRule,
    HuecoSurtidoRule,
    CanibalizacionRule,
]
