# backend/app/services/insight_engine/__init__.py
"""
Insight Engine v2.0 - Motor de detección automática de anomalías.

Issue #506: Sistema de insights con 10 reglas, impacto económico y feedback loop.

Arquitectura:
- models.py: InsightResult dataclass
- rules/base.py: BaseInsightRule ABC
- rules/*.py: Implementaciones de reglas por categoría
- engine.py: InsightEngineService (orquestador)

Uso:
    from app.services.insight_engine import insight_engine_service

    # Ejecutar audit completo
    insights = await insight_engine_service.run_audit(db, pharmacy_id)

    # Registrar feedback
    await insight_engine_service.submit_feedback(
        db, pharmacy_id, insight_hash, "snooze", days=7
    )
"""

from .engine import InsightEngineService, insight_engine_service
from .models import InsightResult

__all__ = [
    "InsightEngineService",
    "insight_engine_service",
    "InsightResult",
]
