# backend/app/parsers/__init__.py
"""
Parsers para diferentes formatos de ERPs farmacéuticos
"""

from app.parsers.base_parser import BaseParser
from app.parsers.farmanager_parser import FarmanagerParser
from app.parsers.farmatic_parser import FarmaticParser
from app.parsers.parser_factory import ParserFactory

# Inventory parsers (Issue #476)
from app.parsers.inventory import BaseInventoryParser, FarmanagerInventoryParser

__all__ = [
    # Sales parsers
    "BaseParser",
    "FarmaticParser",
    "FarmanagerParser",
    "ParserFactory",
    # Inventory parsers (Issue #476)
    "BaseInventoryParser",
    "FarmanagerInventoryParser",
]
