"""
Enumerations for xFarma models

This module contains all enum types used across the application models.
"""

import enum


class PrescriptionCategory(str, enum.Enum):
    """
    Categorías de productos de prescripción (Issue #16)

    Clasifica productos que requieren prescripción médica según criterios
    farmacéuticos y regulatorios del Sistema Nacional de Salud español.
    """

    # Prescripción especializada (Prioridad 1-2)
    FORMULAS_MAGISTRALES = "formulas_magistrales"
    VACUNAS_INDIVIDUALIZADAS = "vacunas_individualizadas"

    # Material sanitario financiado (Prioridad 3-6)
    TIRAS_REACTIVAS_GLUCOSA = "tiras_reactivas_glucosa"
    INCONTINENCIA_FINANCIADA = "incontinencia_financiada"
    EFECTOS_FINANCIADOS = "efectos_financiados"
    ORTOPEDIA_FINANCIADA = "ortopedia_financiada"

    # Dietoterápicos (Prioridad 7)
    DIETOTERAPICOS = "dietoterapicos"

    # Veterinaria (Prioridad 8)
    VETERINARIA = "veterinaria"

    # Conjunto homogéneo (Prioridad 9)
    CONJUNTO_HOMOGENEO = "conjunto_homogeneo"

    # Márgenes especiales RD 823/2008 (Prioridad 10-12)
    MARGEN_ESPECIAL_3 = "margen_especial_3"  # PVL >= 500€
    MARGEN_ESPECIAL_2 = "margen_especial_2"  # 200€ <= PVL < 500€
    MARGEN_ESPECIAL_1 = "margen_especial_1"  # 91.63€ <= PVL < 200€

    # Medicamentos estándar (Prioridad 13)
    MEDICAMENTOS = "medicamentos"

    # Productos no comercializados (Prioridad 3 - Issue #432)
    NO_COMERCIALIZADO = "no_comercializado"

    # Productos no financiados (Prioridad 15)
    USO_HUMANO_NO_FINANCIADO = "uso_humano_no_financiado"
