# backend/app/models/__init__.py
"""
Importación de todos los modelos SQLAlchemy.
Cada modelo tiene extend_existing=True para manejar importaciones múltiples.

NOTA IMPORTANTE (2025-09-07):
- Los modelos se importan UNA SOLA VEZ aquí
- NO importar también en safe_model_registry() para evitar duplicados
- En Render con múltiples workers esto causa "Multiple classes found for path"
"""

from .audit_log import AuditAction, AuditLog, AuditSeverity

# Importar la base común
from .backup_metadata import BackupMetadata  # Issue #348
from .base import Base
from .catalog_sync_history import CatalogSyncHistory, SyncStatus, SyncType, TriggerType  # Issue #349
from .cima_stall_event import CIMAStallEvent
from .dim_date import DimDate  # Issue #503: Date Dimension para Time Intelligence

# ERP Direct Access (Pivot 2026)
from .erp_sync_state import ERPSyncState, SyncStatusEnum as ERPSyncStatus

# License Cache (Pivot 2026 - Issue #569)
from .license_cache import LicenseCache, GRACE_PERIOD_DAYS

# Enums (Issue #16)
from .enums import PrescriptionCategory

# Sales pipeline models
from .file_upload import FileType, FileUpload, UploadStatus
from .homogeneous_group import HomogeneousGroup
from .homogeneous_group_master import HomogeneousGroupMaster
from .insight_feedback import (  # Issue #506: Insight Engine
    InsightCategory,
    InsightFeedback,
    InsightFeedbackAction,
    InsightSeverity,
)
from .narrative_feedback import NarrativeFeedback  # Issue #509: Executive Summary NLG
from .action_tracking import (  # Issue #514: ROI Tracker
    ActionStatus,
    ActionTracking,
    ActionType,
    MonthlyROISummary,
)
from .intercambiable_group import IntercambiableGroup  # Issue #446: Taxonomía venta libre
from .interchangeable_curated_group import (  # Issue #521: Admin UI grupos curados
    InterchangeableCuratedGroup,
    InterchangeableGroupMember,
)
from .inventory_snapshot import InventorySnapshot  # Issue #476: Inventario
from .brand_alias import BrandAlias, BrandAliasAction  # Issue #XXX: Brand aliases
from .category_alias import CategoryAlias  # Issue #459: Category normalization en DB
from .keyword_override import KeywordOverride, KeywordType  # Issue #449: Keywords dinámicos
from .product_cluster import ClusterState, ProductCluster  # Issue #456: Pipeline clasificación
from .product_correction import CorrectionType, PredictionSource, ProductCorrection  # Issue #457: Feedback Loop

# Auth & Security models
from .invitation import Invitation
from .nomenclator_local import NomenclatorLocal

# Core models
from .pharmacy import Pharmacy
from .pharmacy_homogeneous_metrics import PharmacyHomogeneousMetrics

# Analytics models
from .pharmacy_partners import PharmacyPartner
from .pharmacy_targets import DEFAULT_TARGETS, PharmacyTarget  # Issue #510: Benchmarks
from .seasonality_index import SECTOR_SEASONALITY_DEFAULTS, SeasonalityIndex  # Issue #507
from .prescription_reference_list import PrescriptionReferenceList
from .product_catalog import ProductCatalog
from .product_catalog_vet import ProductCatalogVet  # Issue #354: Integración CIMAVet
from .product_catalog_venta_libre import ProductCatalogVentaLibre  # Issue #457: Catálogo venta libre
from .sales_data import SalesData
from .sales_enrichment import SalesEnrichment
from .system_health import DeveloperLog, PerformanceSnapshot, SystemAlert, SystemHealthMetric

# Materialized Views for ETL Nocturno (Issue #543)
from .materialized_views import (
    MVSalesMonthly,
    MVSalesCategory,
    MVSalesBrand,
    MVStockKPIs,
    MVWeeklyKPIs,
    ETLRunLog,
)

# RBAC models (Issue #348)
from .role import Role

# System health models
from .system_status import SystemComponent, SystemStatus, SystemStatusEnum
from .user import User

# Exportar todos los modelos y enums
__all__ = [
    # Base
    "Base",
    # Core models
    "Pharmacy",
    "User",
    # Sales pipeline models
    "FileUpload",
    "UploadStatus",
    "FileType",
    "SalesData",
    "ProductCatalog",
    "ProductCatalogVet",  # Issue #354: Integración CIMAVet
    "ProductCatalogVentaLibre",  # Issue #457: Catálogo venta libre interno
    "SalesEnrichment",
    "NomenclatorLocal",
    # Analytics models
    "PharmacyPartner",
    "PharmacyTarget",  # Issue #510: Benchmarks
    "DEFAULT_TARGETS",  # Issue #510: Benchmarks
    "SeasonalityIndex",  # Issue #507: Estacionalidad
    "SECTOR_SEASONALITY_DEFAULTS",  # Issue #507: Estacionalidad
    "HomogeneousGroup",
    "HomogeneousGroupMaster",
    "InsightCategory",  # Issue #506: Insight Engine
    "InsightFeedback",  # Issue #506: Insight Engine
    "InsightFeedbackAction",  # Issue #506: Insight Engine
    "InsightSeverity",  # Issue #506: Insight Engine
    "NarrativeFeedback",  # Issue #509: Executive Summary NLG
    "ActionTracking",  # Issue #514: ROI Tracker
    "ActionType",  # Issue #514: ROI Tracker
    "ActionStatus",  # Issue #514: ROI Tracker
    "MonthlyROISummary",  # Issue #514: ROI Tracker
    "IntercambiableGroup",  # Issue #446: Taxonomía venta libre
    "InterchangeableCuratedGroup",  # Issue #521: Admin UI grupos curados
    "InterchangeableGroupMember",  # Issue #521: Admin UI grupos curados
    "InventorySnapshot",  # Issue #476: Inventario
    "BrandAlias",  # Issue #XXX: Brand aliases
    "BrandAliasAction",  # Issue #XXX: Brand aliases
    "CategoryAlias",  # Issue #459: Category normalization en DB
    "KeywordOverride",  # Issue #449: Keywords dinámicos
    "KeywordType",  # Issue #449: Keywords dinámicos
    "ProductCluster",  # Issue #456: Pipeline clasificación
    "ClusterState",  # Issue #456: Pipeline clasificación
    "ProductCorrection",  # Issue #457: Feedback Loop
    "CorrectionType",  # Issue #457: Feedback Loop
    "PredictionSource",  # Issue #457: Feedback Loop
    "PharmacyHomogeneousMetrics",
    "PrescriptionReferenceList",
    # Auth & Security models
    "Invitation",
    "AuditLog",
    "AuditAction",
    "AuditSeverity",
    # RBAC models (Issue #348)
    "Role",
    "BackupMetadata",
    # System health models
    "SystemStatus",
    "SystemComponent",
    "SystemStatusEnum",
    "SystemHealthMetric",
    "SystemAlert",
    "DeveloperLog",
    "PerformanceSnapshot",
    "CIMAStallEvent",
    # Catalog sync history (Issue #349)
    "CatalogSyncHistory",
    "SyncType",
    "SyncStatus",
    "TriggerType",
    # Date Dimension (Issue #503)
    "DimDate",
    # Materialized Views (Issue #543)
    "MVSalesMonthly",
    "MVSalesCategory",
    "MVSalesBrand",
    "MVStockKPIs",
    "MVWeeklyKPIs",
    "ETLRunLog",
    # Enums (Issue #16)
    "PrescriptionCategory",
    # ERP Direct Access (Pivot 2026)
    "ERPSyncState",
    "ERPSyncStatus",
    # License Cache (Pivot 2026 - Issue #569)
    "LicenseCache",
    "GRACE_PERIOD_DAYS",
]
