# backend/app/middleware/__init__.py
"""
Middlewares para la aplicación xFarma.

Incluye:
- APIVersioningMiddleware: Versionado de API con múltiples estrategias
- AuthenticationMiddleware: Validación global de JWT tokens
- AuditLoggingMiddleware: Registro de operaciones críticas para auditoría
- Utilidades para manejo de versiones en endpoints
- AutoLockMiddleware: Auto-lock por inactividad (Pivot 2026 Local)
- LicenseGuardMiddleware: Kill-switch enforcement (Pivot 2026 Local)
"""

from .auth_middleware import AuditLoggingMiddleware, AuthenticationMiddleware, RateLimitMiddleware
from .autolock_middleware import AutoLockMiddleware
from .license_guard import LicenseGuardMiddleware
from .versioning import APIVersioningMiddleware, get_api_version, requires_version

__all__ = [
    "APIVersioningMiddleware",
    "get_api_version",
    "requires_version",
    "AuthenticationMiddleware",
    "AuditLoggingMiddleware",
    "RateLimitMiddleware",
    # Pivot 2026 Local
    "AutoLockMiddleware",
    "LicenseGuardMiddleware",
]
