# external_data/__init__.py
"""
Sistema de integración con fuentes de datos externas oficiales españolas
- CIMA: Centro de Información de Medicamentos (AEMPS)
- Nomenclator: Sistema de facturación oficial (Ministerio de Sanidad)
- CIMAVet: Medicamentos veterinarios
"""

from .cima_integration import CIMAIntegrationService
from .data_updater import ExternalDataUpdater
from .nomenclator_integration import NomenclatorIntegration, nomenclator_integration

__all__ = [
    "CIMAIntegrationService",
    "nomenclator_integration",
    "NomenclatorIntegration",
    "ExternalDataUpdater",
]
