"""ERP Adapters Package.

Provides unified access to pharmacy ERP databases.
Each adapter translates ERP-specific schemas to unified models.

Supported ERPs:
- Farmanager (MySQL) - PILOT
- Farmatic (SQL Server) - Coming soon
- Nixfarma (SQL Server) - Coming soon
"""

from .base import ERPAdapter
from .models import (
    UnifiedSale,
    UnifiedStock,
    UnifiedOrder,
    UnifiedReceipt,
    UnifiedCustomer,
    UnifiedEmployee,
    OrderLine,
    ReceiptLine,
)

__all__ = [
    "ERPAdapter",
    "UnifiedSale",
    "UnifiedStock",
    "UnifiedOrder",
    "UnifiedReceipt",
    "UnifiedCustomer",
    "UnifiedEmployee",
    "OrderLine",
    "ReceiptLine",
]
