# backend/app/api/simple_version_test.py
"""
Endpoints de prueba simples para verificar el sistema de versionado.
"""

from typing import Any, Dict

import structlog
from fastapi import APIRouter, Request

from app.middleware import get_api_version, requires_version

logger = structlog.get_logger(__name__)
router = APIRouter()


@router.get("/version-test")
async def simple_version_test(request: Request) -> Dict[str, Any]:
    """
    Endpoint simple para probar el sistema de versiones.
    """
    version = get_api_version(request)

    return {
        "message": f"Version test successful - using API {version}",
        "detected_version": version,
        "path": str(request.url.path),
        "method": request.method,
    }


@router.get("/health-version")
async def health_version(request: Request) -> Dict[str, Any]:
    """
    Health check que muestra información de versión.
    """
    version = get_api_version(request)

    return {"status": "ok", "api_version": version, "timestamp": "2025-09-17T16:35:00Z"}


@router.get("/v2-only-feature")
@requires_version("v2")
async def v2_only_feature(request: Request) -> Dict[str, Any]:
    """
    Endpoint que requiere v2 mínimo.
    """
    version = get_api_version(request)

    return {
        "message": "Esta funcionalidad solo está disponible en v2+",
        "api_version": version,
        "features": ["advanced_analytics", "batch_processing", "real_time_sync"],
    }
