"""add_index_nomen_codigo_homogeneo

Revision ID: dbd73a6ea04d
Revises: 20251027_01_user_configured
Create Date: 2025-10-30 22:37:05.888030+01:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'dbd73a6ea04d'
down_revision: Union[str, None] = '20251027_01_user_configured'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """
    Agregar índice en product_catalog.nomen_codigo_homogeneo para mejorar performance
    en queries de filtrado por conjunto homogéneo (Issue #346).

    PATRÓN IDEMPOTENTE (REGLA #14): Verificar existencia antes de crear.
    """
    # Verificar si el índice ya existe (idempotente)
    conn = op.get_bind()
    result = conn.execute(sa.text(
        "SELECT indexname FROM pg_indexes "
        "WHERE tablename='product_catalog' AND indexname='idx_nomen_codigo_homogeneo'"
    ))

    if not result.fetchone():
        # Crear índice solo si no existe
        op.create_index(
            'idx_nomen_codigo_homogeneo',
            'product_catalog',
            ['nomen_codigo_homogeneo'],
            postgresql_using='btree'
        )
        print("✅ Índice idx_nomen_codigo_homogeneo creado exitosamente")
    else:
        print("ℹ️ Índice idx_nomen_codigo_homogeneo ya existe, saltando creación")


def downgrade() -> None:
    """
    Eliminar índice idx_nomen_codigo_homogeneo si existe.
    """
    # Verificar si el índice existe antes de intentar eliminarlo
    conn = op.get_bind()
    result = conn.execute(sa.text(
        "SELECT indexname FROM pg_indexes "
        "WHERE tablename='product_catalog' AND indexname='idx_nomen_codigo_homogeneo'"
    ))

    if result.fetchone():
        op.drop_index('idx_nomen_codigo_homogeneo', table_name='product_catalog')
        print("✅ Índice idx_nomen_codigo_homogeneo eliminado exitosamente")
    else:
        print("ℹ️ Índice idx_nomen_codigo_homogeneo no existe, saltando eliminación")
