"""fix_cimavet_enum_uppercase

Sprint 3 - Issue #354: Corregir enums a uppercase para consistencia con BD.
La BD existente usa uppercase (CIMA, NOMENCLATOR, etc.), agregamos valores uppercase.

Revision ID: a88279eeafbf
Revises: 56d75acd5e02
Create Date: 2025-11-09 09:45:48.330927+01:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'a88279eeafbf'
down_revision: Union[str, None] = '56d75acd5e02'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Agregar valores uppercase (CIMAVET, IN_PROGRESS, etc.) a enums."""
    conn = op.get_bind()

    # 1. Agregar 'CIMAVET' al enum synctype (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'CIMAVET' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'synctype'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE synctype ADD VALUE 'CIMAVET'")
        print("✅ Agregado 'CIMAVET' (uppercase) al enum synctype")
    else:
        print("ℹ️  'CIMAVET' ya existe en synctype")

    # 2. Agregar 'IN_PROGRESS' al enum syncstatus (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'IN_PROGRESS' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'IN_PROGRESS'")
        print("✅ Agregado 'IN_PROGRESS' (uppercase) al enum syncstatus")
    else:
        print("ℹ️  'IN_PROGRESS' ya existe en syncstatus")

    # 3. Agregar 'COMPLETED' al enum syncstatus (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'COMPLETED' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'COMPLETED'")
        print("✅ Agregado 'COMPLETED' (uppercase) al enum syncstatus")
    else:
        print("ℹ️  'COMPLETED' ya existe en syncstatus")

    # 4. Agregar 'FAILED' al enum syncstatus (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'FAILED' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'FAILED'")
        print("✅ Agregado 'FAILED' (uppercase) al enum syncstatus")
    else:
        print("ℹ️  'FAILED' ya existe en syncstatus")

    # 5. Agregar 'AUTOMATIC' al enum triggertype (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'AUTOMATIC' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'triggertype'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE triggertype ADD VALUE 'AUTOMATIC'")
        print("✅ Agregado 'AUTOMATIC' (uppercase) al enum triggertype")
    else:
        print("ℹ️  'AUTOMATIC' ya existe en triggertype")

    # 6. Agregar 'MANUAL' al enum triggertype (uppercase)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'MANUAL' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'triggertype'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE triggertype ADD VALUE 'MANUAL'")
        print("✅ Agregado 'MANUAL' (uppercase) al enum triggertype")
    else:
        print("ℹ️  'MANUAL' ya existe en triggertype")


def downgrade() -> None:
    """NO reversible - PostgreSQL no permite eliminar valores de enums."""
    pass
