"""add_queued_status_to_upload_issue_332

Revision ID: 9c8e278b054e
Revises: 1ebe213175c0
Create Date: 2025-10-24 22:39:04.088372+02:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '9c8e278b054e'
down_revision: Union[str, None] = '1ebe213175c0'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add 'queued' value to uploadstatus enum type
    # PostgreSQL requires ALTER TYPE ... ADD VALUE
    # Check if enum exists first (it won't exist on fresh DBs without tables)
    conn = op.get_bind()
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_type WHERE typname = 'uploadstatus')"
    ))
    enum_exists = result.scalar()

    if enum_exists:
        # Enum exists, add new value after 'PENDING' (uppercase)
        op.execute("ALTER TYPE uploadstatus ADD VALUE IF NOT EXISTS 'QUEUED' AFTER 'PENDING'")


def downgrade() -> None:
    # NOTE: PostgreSQL does not support removing enum values
    # This migration is irreversible in practice
    # If downgrade is needed, would require recreating the entire enum type
    pass
