"""add_rows_duplicates_to_file_uploads

Revision ID: 826a662bc5da
Revises: 246100490c7b
Create Date: 2025-10-23 17:15:35.385898+02:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '826a662bc5da'
down_revision: Union[str, None] = '246100490c7b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Issue #330: Agregar campo para contar duplicados detectados por ventana temporal
    # Check if column exists first (idempotent)
    conn = op.get_bind()
    result = conn.execute(sa.text(
        "SELECT column_name FROM information_schema.columns "
        "WHERE table_name='file_uploads' AND column_name='rows_duplicates'"
    ))

    if not result.fetchone():
        # Column doesn't exist, add it
        op.add_column('file_uploads', sa.Column('rows_duplicates', sa.Integer(), nullable=True, server_default='0'))
        # Actualizar registros existentes para tener valor 0 por defecto
        op.execute("UPDATE file_uploads SET rows_duplicates = 0 WHERE rows_duplicates IS NULL")


def downgrade() -> None:
    # Issue #330: Remover campo de duplicados
    op.drop_column('file_uploads', 'rows_duplicates')
