"""add_prescription_reference_list_table_manual

Revision ID: 796f8d5c313b
Revises: f3cc8610607e
Create Date: 2025-11-07 19:20:44.186545+01:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision: str = '796f8d5c313b'
down_revision: Union[str, None] = 'f3cc8610607e'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Check if table already exists (idempotent)
    conn = op.get_bind()
    result = conn.execute(sa.text("""
        SELECT EXISTS (
            SELECT FROM information_schema.tables
            WHERE table_schema = 'public'
            AND table_name = 'prescription_reference_list'
        )
    """))
    if result.scalar():
        # Table already exists (created by 000_initial_schema via create_all)
        return

    # Crear tabla prescription_reference_list
    op.create_table(
        'prescription_reference_list',
        sa.Column('id', sa.UUID(), nullable=False, server_default=sa.text('gen_random_uuid()')),
        sa.Column('national_code', sa.String(length=20), nullable=False),
        sa.Column('product_name', sa.String(length=500), nullable=False),
        sa.Column('product_description_long', sa.String(length=500), nullable=True),
        sa.Column('category', postgresql.ENUM(
            'formulas_magistrales',
            'vacunas_individualizadas',
            'tiras_reactivas_glucosa',
            'incontinencia_financiada',
            'efectos_financiados',
            'ortopedia_financiada',
            'dietoterapicos',
            'veterinaria',
            'conjunto_homogeneo',
            'margen_especial_3',
            'margen_especial_2',
            'margen_especial_1',
            'medicamentos',
            'uso_humano_no_financiado',
            name='prescription_category_enum',
            create_type=False  # El enum ya existe de Issue #16
        ), nullable=False),
        sa.Column('reference_source', sa.String(length=100), nullable=False),
        sa.Column('pf_code', sa.String(length=20), nullable=True),
        sa.Column('pvp_iva', sa.Numeric(precision=10, scale=2), nullable=True),
        sa.Column('pmf', sa.Numeric(precision=10, scale=2), nullable=True),
        sa.Column('status', sa.String(length=10), nullable=True),
        sa.Column('loaded_at', sa.DateTime(timezone=True), nullable=False, server_default=sa.text('now()')),
        sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
        sa.PrimaryKeyConstraint('id')
    )

    # Crear índices
    op.create_index(
        'ix_prescription_reference_list_national_code',
        'prescription_reference_list',
        ['national_code']
    )
    op.create_index(
        'ix_prescription_reference_list_category',
        'prescription_reference_list',
        ['category']
    )


def downgrade() -> None:
    # Eliminar índices
    op.drop_index('ix_prescription_reference_list_category', table_name='prescription_reference_list')
    op.drop_index('ix_prescription_reference_list_national_code', table_name='prescription_reference_list')

    # Eliminar tabla
    op.drop_table('prescription_reference_list')
