"""add_cimavet_to_synctype_enum

Sprint 3 - Issue #354: CIMAVet integration
Agrega valores 'cimavet', 'in_progress', 'completed', 'failed' a los enums.

Revision ID: 56d75acd5e02
Revises: 93bb5550e341
Create Date: 2025-11-09 09:22:10.664443+01:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '56d75acd5e02'
down_revision: Union[str, None] = '93bb5550e341'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Agregar valores CIMAVet a enums (idempotente)."""
    conn = op.get_bind()

    # 1. Agregar 'cimavet' al enum synctype (si no existe)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'cimavet' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'synctype'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE synctype ADD VALUE 'cimavet'")
        print("✅ Agregado 'cimavet' al enum synctype")
    else:
        print("ℹ️  'cimavet' ya existe en synctype")

    # 2. Agregar 'in_progress' al enum syncstatus (si no existe)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'in_progress' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'in_progress'")
        print("✅ Agregado 'in_progress' al enum syncstatus")
    else:
        print("ℹ️  'in_progress' ya existe en syncstatus")

    # 3. Agregar 'completed' al enum syncstatus (si no existe)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'completed' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'completed'")
        print("✅ Agregado 'completed' al enum syncstatus")
    else:
        print("ℹ️  'completed' ya existe en syncstatus")

    # 4. Agregar 'failed' al enum syncstatus (si no existe)
    result = conn.execute(sa.text(
        "SELECT EXISTS (SELECT 1 FROM pg_enum WHERE enumlabel = 'failed' "
        "AND enumtypid = (SELECT oid FROM pg_type WHERE typname = 'syncstatus'))"
    ))
    if not result.fetchone()[0]:
        op.execute("ALTER TYPE syncstatus ADD VALUE 'failed'")
        print("✅ Agregado 'failed' al enum syncstatus")
    else:
        print("ℹ️  'failed' ya existe en syncstatus")


def downgrade() -> None:
    """
    NO reversible: PostgreSQL no permite eliminar valores de enums.
    Para revertir, se requeriría:
    1. Eliminar constraint del tipo enum
    2. Recrear enum sin los valores
    3. Recrear constraint
    4. Migrar datos existentes

    Por seguridad, downgrade no implementado.
    """
    pass
