"""add_composite_index_enrichment_progress_tracking

Revision ID: 4af31b1c94f6
Revises: 20250112_unique_sales
Create Date: 2025-10-13 20:27:38.117355+02:00

"""
from typing import Sequence, Union

from alembic import op


# revision identifiers, used by Alembic.
revision: str = '4af31b1c94f6'
down_revision: Union[str, None] = '20250112_unique_sales'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """
    Issue #252 Code Review - Critical Blocker #1:
    Añade índice compuesto para optimizar queries de progreso de enriquecimiento.

    Query optimizada en upload.py líneas 614-745:
    - Usa JOIN sales_data → sales_enrichment
    - Filtra por upload_id (vía sales_data)
    - Agrupa por enrichment_status, match_method

    Índice previo: idx_enrichment_pharmacy_lookup (sales_data_id, enrichment_status)
    Nuevo índice: idx_enrichment_progress_tracking (sales_data_id, enrichment_status, match_method)

    Performance esperado:
    - Reduce query time de ~100ms → ~20ms (5x) con 50k registros
    - Soporta agregaciones CASE sin table scans adicionales
    """
    # Eliminar índice anterior más limitado
    op.drop_index('idx_enrichment_pharmacy_lookup', table_name='sales_enrichment')

    # Crear nuevo índice compuesto optimizado para queries de progreso
    op.create_index(
        'idx_enrichment_progress_tracking',
        'sales_enrichment',
        ['sales_data_id', 'enrichment_status', 'match_method'],
        unique=False
    )


def downgrade() -> None:
    """Revertir a índice anterior si hay problemas."""
    # Eliminar índice nuevo
    op.drop_index('idx_enrichment_progress_tracking', table_name='sales_enrichment')

    # Restaurar índice anterior
    op.create_index(
        'idx_enrichment_pharmacy_lookup',
        'sales_enrichment',
        ['sales_data_id', 'enrichment_status'],
        unique=False
    )
