"""add_parsing_validating_saving_to_uploadstatus_enum

Revision ID: 246100490c7b
Revises: 20250114_sale_time
Create Date: 2025-10-23 10:20:44.696451+02:00

Issue #329: Agrega estados granulares de progreso al enum UploadStatus
- PARSING: Parseando archivo ERP
- VALIDATING: Validando datos parseados
- SAVING: Guardando en base de datos

Estos estados permiten feedback más detallado durante el proceso de upload.
"""
from typing import Sequence, Union

from alembic import op


# revision identifiers, used by Alembic.
revision: str = '246100490c7b'
down_revision: Union[str, None] = '20250114_sale_time'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """
    Agrega valores PARSING, VALIDATING, SAVING al enum uploadstatus.

    PostgreSQL requiere ALTER TYPE ... ADD VALUE para agregar valores a enums.
    Los nuevos valores se agregan DESPUÉS de PENDING y ANTES de PROCESSING.
    """
    # Agregar PARSING después de PENDING
    op.execute("ALTER TYPE uploadstatus ADD VALUE IF NOT EXISTS 'PARSING' AFTER 'PENDING'")

    # Agregar VALIDATING después de PARSING
    op.execute("ALTER TYPE uploadstatus ADD VALUE IF NOT EXISTS 'VALIDATING' AFTER 'PARSING'")

    # Agregar SAVING después de VALIDATING
    op.execute("ALTER TYPE uploadstatus ADD VALUE IF NOT EXISTS 'SAVING' AFTER 'VALIDATING'")


def downgrade() -> None:
    """
    IMPORTANTE: PostgreSQL NO permite eliminar valores de enums directamente.

    Para hacer downgrade completo, necesitarías:
    1. Crear enum temporal sin los valores
    2. Migrar datos existentes
    3. Eliminar enum viejo
    4. Renombrar enum temporal

    Por simplicidad, esta migración es one-way (no reversible).
    Si necesitas revertir, restaura desde backup de base de datos.
    """
    # PostgreSQL no soporta DROP VALUE en enums
    # Downgrade requiere recrear el enum completamente
    pass
