"""Add index on sales_data.upload_id for /upload/history performance.

Revision ID: 20260102_01
Revises: 20260101_01
Create Date: 2026-01-02

Issue: Memory exceeded limit on Render due to slow /upload/history endpoint.
Fix: Add index on upload_id to speed up GROUP BY queries.

Note: Fixed down_revision from f2610595fadb to 20260101_01 to resolve
multiple heads issue (Issue #540).
"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "20260102_01"
down_revision = "20260101_01"
branch_labels = None
depends_on = None


def upgrade():
    # Verificar si el índice ya existe (idempotente)
    conn = op.get_bind()
    result = conn.execute(
        sa.text(
            """
            SELECT 1 FROM pg_indexes
            WHERE tablename = 'sales_data'
            AND indexname = 'ix_sales_data_upload_id'
            """
        )
    )
    if not result.fetchone():
        op.create_index(
            "ix_sales_data_upload_id",
            "sales_data",
            ["upload_id"],
            unique=False,
        )


def downgrade():
    op.drop_index("ix_sales_data_upload_id", table_name="sales_data")
