"""Rename tos_mucosidad to mucosidad_respiratoria

Revision ID: 20251220_02
Revises: 20251220_01
Create Date: 2025-12-20

Issue #457: Rename category for better semantic accuracy.
Acetilcisteina and other mucolytics don't necessarily involve coughing.
"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '20251220_02_rename_tos'
down_revision = '20251220_01_venta_libre_catalog'
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Rename 'tos_mucosidad' -> 'mucosidad_respiratoria' in all category columns."""
    conn = op.get_bind()

    # 1. Update ProductCatalogVentaLibre.ml_category
    conn.execute(sa.text("""
        UPDATE product_catalog_venta_libre
        SET ml_category = 'mucosidad_respiratoria'
        WHERE ml_category = 'tos_mucosidad'
    """))

    # 2. Update ProductCatalogVentaLibre.verified_category
    conn.execute(sa.text("""
        UPDATE product_catalog_venta_libre
        SET verified_category = 'mucosidad_respiratoria'
        WHERE verified_category = 'tos_mucosidad'
    """))

    # 3. Update SalesEnrichment.ml_category
    conn.execute(sa.text("""
        UPDATE sales_enrichment
        SET ml_category = 'mucosidad_respiratoria'
        WHERE ml_category = 'tos_mucosidad'
    """))

    # Log counts for visibility
    result = conn.execute(sa.text("""
        SELECT
            (SELECT COUNT(*) FROM product_catalog_venta_libre WHERE ml_category = 'mucosidad_respiratoria') as catalog_count,
            (SELECT COUNT(*) FROM sales_enrichment WHERE ml_category = 'mucosidad_respiratoria') as enrichment_count
    """))
    row = result.fetchone()
    print(f"Updated categories - Catalog: {row[0]}, SalesEnrichment: {row[1]}")


def downgrade() -> None:
    """Revert 'mucosidad_respiratoria' -> 'tos_mucosidad'."""
    conn = op.get_bind()

    conn.execute(sa.text("""
        UPDATE product_catalog_venta_libre
        SET ml_category = 'tos_mucosidad'
        WHERE ml_category = 'mucosidad_respiratoria'
    """))

    conn.execute(sa.text("""
        UPDATE product_catalog_venta_libre
        SET verified_category = 'tos_mucosidad'
        WHERE verified_category = 'mucosidad_respiratoria'
    """))

    conn.execute(sa.text("""
        UPDATE sales_enrichment
        SET ml_category = 'tos_mucosidad'
        WHERE ml_category = 'mucosidad_respiratoria'
    """))
