"""increase_cima_nregistro_size

Revision ID: 20251203_02_increase_nregistro
Revises: 20251203_add_cima_nregistro
Create Date: 2025-12-03

Aumenta el tamaño de cima_nregistro de 20 a 50 caracteres para
acomodar nregistros largos de algunos productos CIMA.
"""

from alembic import op
import sqlalchemy as sa


revision = "20251203_02_increase_nregistro"
down_revision = "20251203_add_cima_nregistro"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Aumentar tamaño del campo cima_nregistro
    op.alter_column(
        "product_catalog",
        "cima_nregistro",
        type_=sa.String(50),
        existing_type=sa.String(20),
        existing_nullable=True,
    )


def downgrade() -> None:
    op.alter_column(
        "product_catalog",
        "cima_nregistro",
        type_=sa.String(20),
        existing_type=sa.String(50),
        existing_nullable=True,
    )
