"""merge_three_heads_render_deployment

Fix deployment failure in Render caused by multiple heads in Alembic.

Three migrations were created from the same down_revision (fc38b8d391de):
- df009b59a1e6: drop_unique_constraint_sales_data
- 2025110401: add_performance_indexes
- 20251105: catalog_sync_history

This merge migration unifies all three heads into a single linear history.

Revision ID: 20251105_02_merge
Revises: df009b59a1e6, 2025110401, 20251105_catalog_sync_history
Create Date: 2025-11-05 12:00:00.000000+01:00

"""
from typing import Sequence, Union



# revision identifiers, used by Alembic.
revision: str = '20251105_02_merge'
down_revision: Union[str, None] = ('df009b59a1e6', '2025110401', '20251105_catalog_sync_history')
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """
    Merge migration - no schema changes needed.

    All schema changes are already applied by the individual migrations:
    - df009b59a1e6: Dropped UNIQUE constraint on sales_data
    - 2025110401: Added 4 performance indexes
    - 20251105: Created catalog_sync_history table

    This migration only unifies the revision history.
    """
    pass


def downgrade() -> None:
    """
    Merge migration - no schema changes to revert.

    Downgrade will revert to the three separate heads.
    """
    pass
