"""add_user_modified_at_to_pharmacy_partners

Revision ID: 1ebe213175c0
Revises: 826a662bc5da
Create Date: 2025-10-24 14:17:53.306359+02:00

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1ebe213175c0'
down_revision: Union[str, None] = '826a662bc5da'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add user_modified_at column to track actual user modifications
    # Check if column exists first (idempotent)
    conn = op.get_bind()
    result = conn.execute(sa.text(
        "SELECT column_name FROM information_schema.columns "
        "WHERE table_name='pharmacy_partners' AND column_name='user_modified_at'"
    ))

    if not result.fetchone():
        # Column doesn't exist, add it
        op.add_column(
            'pharmacy_partners',
            sa.Column('user_modified_at', sa.DateTime(timezone=True), nullable=True)
        )


def downgrade() -> None:
    # Remove user_modified_at column
    op.drop_column('pharmacy_partners', 'user_modified_at')
